/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.markers.DummyMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class JsonDecorationType
extends MapDecorationType<CustomMapDecoration, DummyMapBlockMarker<CustomMapDecoration>> {
    public static final Codec<JsonDecorationType> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3825.field_25012.optionalFieldOf("target_block").forGetter(JsonDecorationType::getTarget), (App)Codec.STRING.optionalFieldOf("name").forGetter(JsonDecorationType::getName), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(JsonDecorationType::getRotation), (App)Codec.INT.optionalFieldOf("map_color", (Object)0).forGetter(JsonDecorationType::getDefaultMapColor), (App)class_6895.method_40340((class_5321)class_7924.field_41246).optionalFieldOf("target_structures").forGetter(JsonDecorationType::getAssociatedStructure)).apply((Applicative)instance, JsonDecorationType::new));
    public static final Codec<JsonDecorationType> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_3825.field_25012.optionalFieldOf("target_block").forGetter(JsonDecorationType::getTarget), (App)Codec.STRING.optionalFieldOf("name").forGetter(JsonDecorationType::getName), (App)Codec.FLOAT.optionalFieldOf("rotation", (Object)Float.valueOf(0.0f)).forGetter(JsonDecorationType::getRotation), (App)Codec.INT.optionalFieldOf("map_color", (Object)0).forGetter(JsonDecorationType::getDefaultMapColor)).apply((Applicative)instance, JsonDecorationType::new));
    @Nullable
    private final class_3825 target;
    @Nullable
    private final String name;
    @Nullable
    private final class_6885<class_3195> structures;
    private final int mapColor;
    private final float rotation;

    public JsonDecorationType(Optional<class_3825> target) {
        this(target, Optional.empty(), 0.0f, 0);
    }

    public JsonDecorationType(Optional<class_3825> target, Optional<String> name, float rotation, int mapColor) {
        this(target, name, rotation, mapColor, Optional.empty());
    }

    public JsonDecorationType(Optional<class_3825> target, Optional<String> name, float rotation, int mapColor, Optional<class_6885<class_3195>> structure) {
        this.target = target.orElse(null);
        this.name = name.orElse(null);
        this.rotation = rotation;
        this.structures = structure.orElse(null);
        this.mapColor = 0;
    }

    public Optional<class_3825> getTarget() {
        return Optional.ofNullable(this.target);
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public float getRotation() {
        return this.rotation;
    }

    @Override
    public Optional<class_6885<class_3195>> getAssociatedStructure() {
        return Optional.ofNullable(this.structures);
    }

    @Override
    public int getDefaultMapColor() {
        return this.mapColor;
    }

    @Override
    public boolean hasMarker() {
        return this.target != null;
    }

    public class_2960 getId() {
        return Utils.getID(this);
    }

    @Override
    @Nullable
    public CustomMapDecoration loadDecorationFromBuffer(class_2540 buffer) {
        try {
            return new CustomMapDecoration(this, buffer);
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this.getId() + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public DummyMapBlockMarker<CustomMapDecoration> loadMarkerFromNBT(class_2487 compound) {
        if (this.hasMarker()) {
            DummyMapBlockMarker<CustomMapDecoration> marker = new DummyMapBlockMarker<CustomMapDecoration>(this);
            try {
                marker.loadFromNBT(compound);
                return marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this.getId() + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public DummyMapBlockMarker<CustomMapDecoration> getWorldMarkerFromWorld(class_1922 reader, class_2338 pos) {
        if (this.target != null && this.target.method_16768(reader.method_8320(pos), class_5819.method_43047())) {
            return new DummyMapBlockMarker<CustomMapDecoration>(this, pos);
        }
        return null;
    }

    @Override
    public MapBlockMarker<CustomMapDecoration> getDefaultMarker(class_2338 pos) {
        return new DummyMapBlockMarker<CustomMapDecoration>(this, pos);
    }
}

