/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.DummyMapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
extends MapDecorationType<D, M> {
    public static final Codec<CustomDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("custom_type").forGetter(MapDecorationType::getCustomFactoryID)).apply((Applicative)instance, MapDecorationRegistry::getCustomType));
    private final class_2960 id;
    private final BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory;
    private final Supplier<M> markerFactory;
    private final BiFunction<class_1922, class_2338, M> markerFromWorldFactory;

    public CustomDecorationType(class_2960 typeId, Supplier<M> markerFactory, BiFunction<class_1922, class_2338, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory) {
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
        this.id = typeId;
    }

    public CustomDecorationType(class_2960 typeId, BiFunction<MapDecorationType<?, ?>, class_2540, D> decoFromBuffer) {
        this(typeId, null, null, decoFromBuffer);
    }

    @Override
    public class_2960 getCustomFactoryID() {
        return this.id;
    }

    @Override
    public boolean hasMarker() {
        return this.markerFactory != null;
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(class_2540 buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(class_2487 compound) {
        if (this.hasMarker()) {
            MapBlockMarker marker = (MapBlockMarker)this.markerFactory.get();
            try {
                marker.loadFromNBT(compound);
                return (M)marker;
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this + ": " + e);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(class_1922 reader, class_2338 pos) {
        return (M)(this.hasMarker() ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }

    @Override
    public MapBlockMarker<D> getDefaultMarker(class_2338 pos) {
        if (this.markerFactory != null) {
            MapBlockMarker m = (MapBlockMarker)this.markerFactory.get();
            m.setPos(pos);
            return m;
        }
        return new DummyMapBlockMarker(this, pos);
    }
}

