/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.client.DecorationRenderer;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4075;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.jetbrains.annotations.ApiStatus;

public class MapDecorationClientManager
extends class_4075 {
    public static final class_2960 LOCATION_MAP_MARKERS = Moonlight.res("textures/atlas/map_markers.png");
    public static final class_1921 MAP_MARKERS_RENDER_TYPE = class_1921.method_23028((class_2960)LOCATION_MAP_MARKERS);
    private static MapDecorationClientManager instance;
    private static final Map<MapDecorationType<?, ?>, DecorationRenderer<?>> RENDERERS;

    public MapDecorationClientManager() {
        super(class_310.method_1551().method_1531(), LOCATION_MAP_MARKERS, Moonlight.res("map_markers"));
        instance = this;
    }

    public static class_1058 getAtlasSprite(class_2960 location) {
        return instance.method_18667(location);
    }

    public static <T extends CustomMapDecoration> void registerCustomRenderer(MapDecorationType<T, ?> type, DecorationRenderer<T> renderer) {
        RENDERERS.put(type, renderer);
    }

    private static <T extends CustomMapDecoration> DecorationRenderer<T> simpleRenderer(MapDecorationType<T, ?> type) {
        class_2960 id = Utils.getID(type);
        class_2960 texture = new class_2960(id.method_12836(), "map_marker/" + id.method_12832());
        return new DecorationRenderer(texture);
    }

    @ApiStatus.Internal
    public static <E extends CustomMapDecoration> DecorationRenderer<E> getRenderer(E decoration) {
        return RENDERERS.computeIfAbsent(decoration.getType(), t -> MapDecorationClientManager.simpleRenderer(decoration.getType()));
    }

    @ApiStatus.Internal
    public static <T extends CustomMapDecoration> boolean render(T decoration, class_4587 matrixStack, class_4588 vertexBuilder, class_4597 buffer, class_22 mapData, boolean isOnFrame, int light, int index) {
        DecorationRenderer<T> renderer = MapDecorationClientManager.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, vertexBuilder, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }

    static {
        RENDERERS = Maps.newHashMap();
    }
}

