/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.map.CustomDataHolder;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.fabric.MapDecorationRegistryImpl;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.CustomDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.JsonDecorationType;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_4926;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class MapDecorationRegistry {
    public static final Codec<MapDecorationType<?, ?>> CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    public static final Codec<MapDecorationType<?, ?>> NETROWK_CODEC = Codec.either(CustomDecorationType.CODEC, JsonDecorationType.NETWORK_CODEC).xmap(either -> (MapDecorationType)either.map(s -> s, c -> c), type -> {
        if (type == null) {
            Moonlight.LOGGER.error("map decoration type cant be null. how did this happen?");
        }
        if (type instanceof CustomDecorationType) {
            CustomDecorationType c = (CustomDecorationType)type;
            return Either.left((Object)c);
        }
        return Either.right((Object)((JsonDecorationType)type));
    });
    public static final Map<class_2960, CustomDataHolder<?>> CUSTOM_MAP_DATA_TYPES = new HashMap();
    public static final class_5321<class_2378<MapDecorationType<?, ?>>> KEY = class_5321.method_29180((class_2960)Moonlight.res((PlatHelper.getPlatform().isFabric() ? "moonlight/" : "") + "map_markers"));
    public static final class_2960 GENERIC_STRUCTURE_ID = Moonlight.res("generic_structure");
    private static final Map<class_2960, CustomDecorationType<?, ?>> CODE_TYPES_FACTORIES = new HashMap();

    public static <T> void registerCustomMapSavedData(class_2960 name, Class<T> type, Function<class_2487, T> load, BiConsumer<class_2487, T> save, class_4926.class_4932<class_22, class_1297, T, Boolean> onItemUpdate, class_4926.class_4932<class_22, class_1799, T, class_2561> onItemTooltip) {
        if (CUSTOM_MAP_DATA_TYPES.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate custom map data registration " + name);
        }
        CUSTOM_MAP_DATA_TYPES.put(name, new CustomDataHolder<T>(name, load, save, onItemUpdate, onItemTooltip));
    }

    public static MapDecorationType<?, ?> getGenericStructure() {
        return MapDecorationRegistry.get(GENERIC_STRUCTURE_ID);
    }

    public static <T extends CustomDecorationType<?, ?>> void registerCustomType(T markerType) {
        CODE_TYPES_FACTORIES.put(markerType.getCustomFactoryID(), markerType);
    }

    public static CustomDecorationType<?, ?> getCustomType(class_2960 resourceLocation) {
        return Objects.requireNonNull(CODE_TYPES_FACTORIES.get(resourceLocation), "No map decoration type with id: " + resourceLocation);
    }

    public static MapDecorationType<?, ?> getAssociatedType(class_6880<class_3195> structure) {
        for (MapDecorationType<?, ?> v : MapDecorationRegistry.getValues()) {
            Optional<class_6885<class_3195>> associatedStructure = v.getAssociatedStructure();
            if (!associatedStructure.isPresent() || !associatedStructure.get().method_40241(structure)) continue;
            return v;
        }
        return MapDecorationRegistry.getGenericStructure();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        MapDecorationRegistryImpl.init();
    }

    public static class_2378<MapDecorationType<?, ?>> hackyGetRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(KEY);
    }

    public static class_2378<MapDecorationType<?, ?>> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(KEY);
    }

    public static Collection<MapDecorationType<?, ?>> getValues() {
        return MapDecorationRegistry.hackyGetRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<MapDecorationType<?, ?>>, MapDecorationType<?, ?>>> getEntries() {
        return MapDecorationRegistry.hackyGetRegistry().method_29722();
    }

    @Nullable
    public static MapDecorationType<? extends CustomMapDecoration, ?> get(String id) {
        return MapDecorationRegistry.get(new class_2960(id));
    }

    public static MapDecorationType<?, ?> get(class_2960 id) {
        class_2378<MapDecorationType<?, ?>> reg = MapDecorationRegistry.hackyGetRegistry();
        MapDecorationType r = (MapDecorationType)reg.method_10223(id);
        if (r == null) {
            return (MapDecorationType)reg.method_10223(GENERIC_STRUCTURE_ID);
        }
        return r;
    }

    public static Optional<MapDecorationType<?, ?>> getOptional(class_2960 id) {
        return MapDecorationRegistry.hackyGetRegistry().method_17966(id);
    }

    @Nullable
    @ApiStatus.Internal
    public static MapBlockMarker<?> readWorldMarker(class_2487 compound) {
        for (Map.Entry<class_5321<MapDecorationType<?, ?>>, MapDecorationType<?, ?>> e : MapDecorationRegistry.getEntries()) {
            String id = e.getKey().method_29177().toString();
            if (!compound.method_10545(id)) continue;
            return e.getValue().loadMarkerFromNBT(compound.method_10562(id));
        }
        return null;
    }

    @ApiStatus.Internal
    public static List<MapBlockMarker<?>> getMarkersFromWorld(class_1922 reader, class_2338 pos) {
        ArrayList list = new ArrayList();
        for (MapDecorationType<?, ?> type : MapDecorationRegistry.getValues()) {
            Object c = type.getWorldMarkerFromWorld(reader, pos);
            if (c == null) continue;
            list.add((MapBlockMarker<?>)c);
        }
        return list;
    }
}

