/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidRegistryImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SoftFluidRegistry {
    public static final class_5321<class_2378<SoftFluid>> KEY = class_5321.method_29180((class_2960)Moonlight.res((PlatHelper.getPlatform().isFabric() ? "moonlight/" : "") + "soft_fluids"));
    public static final class_2960 EMPTY_ID = Moonlight.res("empty");
    private static final Map<class_3611, SoftFluid> FLUID_MAP = new IdentityHashMap<class_3611, SoftFluid>();
    private static final Map<class_1792, SoftFluid> ITEM_MAP = new IdentityHashMap<class_1792, SoftFluid>();

    public static SoftFluid getEmpty() {
        return SoftFluidRegistry.get(EMPTY_ID);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidRegistryImpl.init();
    }

    public static class_2378<SoftFluid> hackyGetRegistry() {
        return Utils.hackyGetRegistry(KEY);
    }

    public static class_2378<SoftFluid> getRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(KEY);
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.hackyGetRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.hackyGetRegistry().method_29722();
    }

    public static SoftFluid get(String id) {
        return SoftFluidRegistry.get(new class_2960(id));
    }

    public static SoftFluid get(class_2960 id) {
        String namespace = id.method_12836();
        class_2378<SoftFluid> reg = SoftFluidRegistry.hackyGetRegistry();
        SoftFluid r = (SoftFluid)reg.method_10223(id);
        if (r == null) {
            if (namespace.equals("selene") || namespace.equals("minecraft")) {
                id = Moonlight.res(id.method_12832());
            }
            if ((r = (SoftFluid)reg.method_10223(id)) == null) {
                return (SoftFluid)reg.method_10223(EMPTY_ID);
            }
        }
        return r;
    }

    public static Optional<SoftFluid> getOptional(class_2960 id) {
        String namespace = id.method_12836();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.method_12832());
        }
        return SoftFluidRegistry.hackyGetRegistry().method_17966(id);
    }

    public static SoftFluid fromForgeFluid(class_3611 fluid) {
        return FLUID_MAP.getOrDefault(fluid, SoftFluidRegistry.getEmpty());
    }

    @NotNull
    public static SoftFluid fromItem(class_1792 filledContainerItem) {
        return ITEM_MAP.getOrDefault(filledContainerItem, SoftFluidRegistry.getEmpty());
    }

    private static void populateSlaveMaps() {
        Map<class_1792, SoftFluid> itemMap = ITEM_MAP;
        itemMap.clear();
        Map<class_3611, SoftFluid> fluidsMap = FLUID_MAP;
        fluidsMap.clear();
        for (SoftFluid s : SoftFluidRegistry.getValues()) {
            if (!PlatHelper.isModLoaded(s.getFromMod())) continue;
            s.getEquivalentFluids().forEach(f -> fluidsMap.put((class_3611)f, s));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || s != BuiltInSoftFluids.WATER.get()) {
                    itemMap.put((class_1792)i, s);
                }
            });
        }
    }

    @ApiStatus.Internal
    public static void postInitClient() {
        SoftFluidRegistry.populateSlaveMaps();
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(class_3222 player, boolean o) {
        ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
    }

    @ApiStatus.Internal
    public static void onDataLoad() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidRegistry.registerExistingVanillaFluids(FLUID_MAP, ITEM_MAP);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids(Map<class_3611, SoftFluid> fluidMap, Map<class_1792, SoftFluid> itemMap) {
        void var1_1;
        SoftFluidRegistryImpl.registerExistingVanillaFluids(fluidMap, (Map<class_1792, SoftFluid>)var1_1);
    }
}

