/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_777;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class VertexUtil {
    private static int getFormatLength() {
        return class_290.field_1590.method_1359();
    }

    public static List<class_777> swapSprite(List<class_777> quads, class_1058 sprite) {
        ArrayList<class_777> newList = new ArrayList<class_777>();
        for (class_777 q : quads) {
            newList.add(VertexUtil.swapSprite(q, sprite));
        }
        return newList;
    }

    public static class_777 swapSprite(class_777 q, class_1058 sprite) {
        class_1058 oldSprite = q.method_35788();
        int formatLength = VertexUtil.getFormatLength();
        int[] v = Arrays.copyOf(q.method_3357(), q.method_3357().length);
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalU = Float.intBitsToFloat(v[i * formatLength + 4]);
            float originalV = Float.intBitsToFloat(v[i * formatLength + 5]);
            v[i * formatLength + 4] = Float.floatToIntBits(originalU - oldSprite.method_4594() + sprite.method_4594());
            v[i * formatLength + 5] = Float.floatToIntBits(originalV - oldSprite.method_4593() + sprite.method_4593());
        }
        return new class_777(v, q.method_3359(), q.method_3358(), sprite, q.method_24874());
    }

    public static void transformVertices(int[] v, Matrix3f transform) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]) - 0.5f;
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]) - 0.5f;
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]) - 0.5f;
            Vector3f vector3f = new Vector3f(originalX, originalY, originalZ);
            vector3f.mul((Matrix3fc)transform);
            v[i * formatLength] = Float.floatToIntBits(vector3f.x() + 0.5f);
            v[i * formatLength + 1] = Float.floatToIntBits(vector3f.y() + 0.5f);
            v[i * formatLength + 2] = Float.floatToIntBits(vector3f.z() + 0.5f);
        }
    }

    public static void transformVertices(int[] v, class_4587 stack, class_1058 sprite) {
        Vector4f vector4f = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        vector4f.mul((Matrix4fc)stack.method_23760().method_23761());
        VertexUtil.moveVertices(v, vector4f.x(), vector4f.y(), vector4f.z());
    }

    public static void rotateVerticesY(int[] v, class_1058 sprite, class_2470 rot) {
        Matrix3f matrix = rot.method_26383().method_35814();
        VertexUtil.transformVertices(v, matrix);
    }

    public static void moveVertices(int[] v, class_2350 dir, float amount) {
        int formatLength = VertexUtil.getFormatLength();
        int axis = dir.method_10166().ordinal();
        float step = amount * (float)dir.method_10171().method_10181();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float original = Float.intBitsToFloat(v[i * formatLength + axis]);
            v[i * formatLength + axis] = Float.floatToIntBits(original + step);
        }
    }

    public static void moveVertices(int[] v, float x, float y, float z) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX + x);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY + y);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ + z);
        }
    }

    public static void scaleVertices(int[] v, float scale) {
        int formatLength = VertexUtil.getFormatLength();
        for (int i = 0; i < v.length / formatLength; ++i) {
            float originalX = Float.intBitsToFloat(v[i * formatLength]);
            v[i * formatLength] = Float.floatToIntBits(originalX * scale);
            float originalY = Float.intBitsToFloat(v[i * formatLength + 1]);
            v[i * formatLength + 1] = Float.floatToIntBits(originalY * scale);
            float originalZ = Float.intBitsToFloat(v[i * formatLength + 2]);
            v[i * formatLength + 2] = Float.floatToIntBits(originalZ * scale);
        }
    }
}

