/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.model.fabric;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.impl.client.indigo.renderer.IndigoRenderer;
import net.mehvahdjukaar.moonlight.api.client.model.BakedQuadBuilder;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_4590;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BakedQuadBuilderImpl
implements BakedQuadBuilder {
    private final QuadEmitter inner;
    private int vertexIndex = 0;
    private Matrix4f transform;
    class_1058 sprite = null;

    public static BakedQuadBuilder create(@Nullable class_4590 transformation) {
        return new BakedQuadBuilderImpl(transformation == null ? null : transformation.method_22936());
    }

    private BakedQuadBuilderImpl(@Nullable Matrix4f transform) {
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        this.inner = meshBuilder.getEmitter();
        this.transform = transform;
    }

    @Override
    public BakedQuadBuilder setSprite(class_1058 sprite) {
        this.sprite = sprite;
        this.inner.spriteBake(0, sprite, 4);
        return null;
    }

    @Override
    public BakedQuadBuilder setShade(boolean shade) {
        return this;
    }

    @Override
    public BakedQuadBuilder setAmbientOcclusion(boolean ambientOcclusion) {
        return this;
    }

    @Override
    public BakedQuadBuilder setDirection(class_2350 direction) {
        if (this.transform != null) {
            direction = RotHlpr.rotateDirection(direction, this.transform);
        }
        this.inner.nominalFace(direction);
        return this;
    }

    @Override
    public BakedQuadBuilder pos(float x, float y, float z) {
        if (this.transform != null) {
            Vector3f v = RotHlpr.rotateVertexOnCenterBy(x, y, z, this.transform);
            this.inner.pos(this.vertexIndex, v.x(), v.y(), v.z());
            return this;
        }
        this.inner.pos(this.vertexIndex, x, y, z);
        return this;
    }

    @Override
    public BakedQuadBuilder normal(float x, float y, float z) {
        if (this.transform != null) {
            Vector3f normal = new Vector3f(x, y, z);
            RotHlpr.rotateVertexBy(normal, new Vector3f(), this.transform);
            this.inner.normal(this.vertexIndex, normal.x(), normal.y(), normal.z());
            return this;
        }
        this.inner.normal(this.vertexIndex, x, y, z);
        return this;
    }

    @Override
    public BakedQuadBuilder color(int rgba) {
        this.inner.spriteColor(this.vertexIndex, 0, rgba);
        return this;
    }

    @Override
    public BakedQuadBuilder uv(float u, float v) {
        this.inner.sprite(this.vertexIndex, 0, u, v);
        return this;
    }

    @Override
    public BakedQuadBuilder lightEmission(int lightLevel) {
        this.inner.material(RendererAccess.INSTANCE.getRenderer().materialFinder().emissive(0, true).find());
        return this;
    }

    @Override
    public BakedQuadBuilder endVertex() {
        ++this.vertexIndex;
        return this;
    }

    @Override
    public BakedQuadBuilder fromVanilla(class_777 quad) {
        this.inner.fromVanilla(quad, IndigoRenderer.MATERIAL_STANDARD, null);
        return null;
    }

    @Override
    public class_777 build() {
        Preconditions.checkNotNull((Object)this.sprite, (Object)"sprite cannot be null");
        return this.inner.toBakedQuad(this.sprite);
    }
}

