/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.BaseMapCodec;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.forge.UtilsImpl;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.MoonlightClient;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatType;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.m_9236_().f_46443_ || bothSides) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        Utils.swapItem(player, hand, oldItem, newItem, false);
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.m_9236_().f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        Utils.swapItem(player, hand, player.m_21120_(hand), newItem);
    }

    @Deprecated(forRemoval=true)
    public static void addStackToExisting(Player player, ItemStack stack, boolean avoidEmptyHands) {
        Utils.addItemOrDrop(player, stack, avoidEmptyHands ? InvPlacer.handOrExistingOrAnyAvoidEmptyHand(InteractionHand.MAIN_HAND) : InvPlacer.handOrExistingOrAny(InteractionHand.MAIN_HAND));
    }

    public static void addItemOrDrop(Player player, ItemStack stack, InvPlacer placer) {
        Inventory inv = player.m_150109_();
        placer.or(InvPlacer.DROP).place(stack, inv, player);
    }

    public static void addItemOrDrop(Player player, ItemStack stack) {
        Utils.addItemOrDrop(player, stack, InvPlacer.existingOrAny());
    }

    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.m_188503_(5) + rand.m_188503_(5);
        }
        return xp;
    }

    public static ResourceLocation getID(@NotNull Block object) {
        return BuiltInRegistries.f_256975_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull EntityType<?> object) {
        return BuiltInRegistries.f_256780_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Biome object) {
        return Utils.hackyGetRegistry(Registries.f_256952_).m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull DamageType type) {
        return Utils.hackyGetRegistry(Registries.f_268580_).m_7981_((Object)type);
    }

    public static ResourceLocation getID(@NotNull ConfiguredFeature<?, ?> object) {
        return Utils.hackyGetRegistry(Registries.f_256911_).m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Item object) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull Fluid object) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull BlockEntityType<?> object) {
        return BuiltInRegistries.f_257049_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull RecipeSerializer<?> object) {
        return BuiltInRegistries.f_256769_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull SoftFluid object) {
        return SoftFluidRegistry.hackyGetRegistry().m_7981_((Object)object);
    }

    @Deprecated(forRemoval=true)
    public static ResourceLocation getID(@NotNull MapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Potion object) {
        return BuiltInRegistries.f_256980_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull MobEffect object) {
        return BuiltInRegistries.f_256974_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull CreativeModeTab object) {
        return BuiltInRegistries.f_279662_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(@NotNull StatType<?> object) {
        return BuiltInRegistries.f_256899_.m_7981_(object);
    }

    public static ResourceLocation getID(@NotNull Object object) {
        if (object instanceof Block) {
            Block b = (Block)object;
            return Utils.getID(b);
        }
        if (object instanceof Item) {
            Item b = (Item)object;
            return Utils.getID(b);
        }
        if (object instanceof EntityType) {
            EntityType b = (EntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof BlockEntityType) {
            BlockEntityType b = (BlockEntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof Biome) {
            Biome b = (Biome)object;
            return Utils.getID(b);
        }
        if (object instanceof Fluid) {
            Fluid b = (Fluid)object;
            return Utils.getID(b);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer b = (RecipeSerializer)object;
            return Utils.getID(b);
        }
        if (object instanceof ConfiguredFeature) {
            ConfiguredFeature c = (ConfiguredFeature)object;
            return Utils.getID(c);
        }
        if (object instanceof Potion) {
            Potion c = (Potion)object;
            return Utils.getID(c);
        }
        if (object instanceof MobEffect) {
            MobEffect c = (MobEffect)object;
            return Utils.getID(c);
        }
        if (object instanceof Supplier) {
            Supplier s = (Supplier)object;
            return Utils.getID(s.get());
        }
        if (object instanceof SoftFluid) {
            SoftFluid s = (SoftFluid)object;
            return Utils.getID(s);
        }
        if (object instanceof MapDecorationType) {
            MapDecorationType s = (MapDecorationType)object;
            return Utils.getID(s);
        }
        if (object instanceof CreativeModeTab) {
            CreativeModeTab t = (CreativeModeTab)object;
            return Utils.getID(t);
        }
        if (object instanceof DamageType) {
            DamageType t = (DamageType)object;
            return Utils.getID(t);
        }
        if (object instanceof StatType) {
            StatType t = (StatType)object;
            return Utils.getID(t);
        }
        throw new UnsupportedOperationException("Unsupported class type " + String.valueOf(object.getClass()) + ". Expected a registry entry for a call to Utils.getID()");
    }

    @Deprecated(forRemoval=true)
    public static <T> boolean isTagged(T entry, Registry<T> registry, TagKey<T> tag) {
        return registry.m_263177_(entry).m_203656_(tag);
    }

    @ApiStatus.Experimental
    public static RegistryAccess hackyGetRegistryAccess() {
        MinecraftServer s = PlatHelper.getCurrentServer();
        if (PlatHelper.getPhysicalSide().isClient()) {
            if (s != null && (s.m_18695_() || !MoonlightClient.isClientThread())) {
                return s.m_206579_();
            }
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                return level.m_9598_();
            }
            WeakReference<RegistryAccess> hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
            if (hack2 != null) {
                return (RegistryAccess)hack2.get();
            }
            throw new UnsupportedOperationException("Failed to get registry access: level was null");
        }
        if (s != null) {
            return s.m_206579_();
        }
        WeakReference<RegistryAccess> hack2 = Moonlight.EARLY_REGISTRY_ACCESS.get();
        if (hack2 != null) {
            return (RegistryAccess)hack2.get();
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static <T> Registry<T> hackyGetRegistry(ResourceKey<Registry<T>> registry) {
        return Utils.hackyGetRegistryAccess().m_175515_(registry);
    }

    public static BlockBehaviour.Properties copyPropertySafe(Block blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)blockBehaviour);
        BlockState state = blockBehaviour.m_49966_();
        p.m_60953_(s -> state.m_60791_());
        p.m_222979_(BlockBehaviour.OffsetType.NONE);
        p.m_60922_((blockState, blockGetter, pos, entityType) -> blockState.m_60783_(blockGetter, pos, Direction.UP) && blockState.m_60791_() < 14);
        p.m_284180_(blockBehaviour.m_284356_());
        p.m_60991_((blockState, blockGetter, blockPos) -> false);
        return p;
    }

    public static BlockHitResult rayTrace(LivingEntity entity, boolean hitsFluids, float partialTicks) {
        return (BlockHitResult)entity.m_19907_(ForgeHelper.getReachDistance(entity), partialTicks, hitsFluids);
    }

    @Deprecated(forRemoval=true)
    public static HitResult rayTrace(LivingEntity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return Utils.rayTrace((Entity)entity, world, blockMode, fluidMode, ForgeHelper.getReachDistance(entity));
    }

    @Deprecated(forRemoval=true)
    public static HitResult rayTrace(Entity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity.m_146892_();
        Vec3 ray = entity.m_20252_(1.0f).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity);
        return world.m_45547_(context);
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name) {
        Utils.awardAdvancement(sp, name, "unlock");
    }

    public static void awardAdvancement(ServerPlayer sp, ResourceLocation name, String unlockProp) {
        PlayerAdvancements advancements;
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(name);
        if (advancement != null && !(advancements = sp.m_8960_()).m_135996_(advancement).m_8193_()) {
            advancements.m_135988_(advancement, unlockProp);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static BlockState readBlockState(CompoundTag compound, @Nullable Level level) {
        HolderLookup.RegistryLookup holderGetter = level != null ? level.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        return NbtUtils.m_247651_((HolderGetter)holderGetter, (CompoundTag)compound);
    }

    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.m_61138_(property)) {
            return (BlockState)to.m_61124_(property, from.m_61143_(property));
        }
        return to;
    }

    @Deprecated(forRemoval=true)
    public static boolean mayBuild(Player player, BlockPos pos) {
        return Utils.mayPerformBlockAction(player, pos, player.m_21205_());
    }

    @Deprecated(forRemoval=true)
    public static boolean mayPerformBlockAction(Player player, BlockPos pos) {
        return Utils.mayPerformBlockAction(player, pos, player.m_21205_());
    }

    public static boolean mayPerformBlockAction(Player player, BlockPos pos, ItemStack stack) {
        boolean result;
        GameType gameMode;
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            gameMode = sp.f_8941_.m_9290_();
        } else {
            gameMode = Minecraft.m_91087_().f_91072_.m_105295_();
        }
        boolean bl = result = !player.m_36187_(player.m_9236_(), pos, gameMode);
        if (!result && gameMode == GameType.ADVENTURE && !stack.m_41619_() && stack.m_204121_(player.m_9236_().m_9598_().m_175515_(Registries.f_256747_), new BlockInWorld((LevelReader)player.m_9236_(), pos, false))) {
            return true;
        }
        return result;
    }

    public static boolean isMethodImplemented(Class<?> original, Class<?> subclass, String name) {
        Method declaredMethod = Utils.findMethodWithMatchingName(subclass, name);
        Method modMethod = Utils.findMethodWithMatchingName(original, name);
        return declaredMethod != null && modMethod != null && Arrays.equals(declaredMethod.getParameterTypes(), modMethod.getParameterTypes());
    }

    private static Method findMethodWithMatchingName(Class<?> clazz, String name) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <K, V, C extends BaseMapCodec<K, V> & Codec<Map<K, V>>> C optionalMapCodec(Codec<K> keyCodec, Codec<V> elementCodec) {
        void var1_1;
        return UtilsImpl.optionalMapCodec(keyCodec, var1_1);
    }

    public static ResourceLocation idWithOptionalNamespace(String id, String namespace) {
        if (id.contains(":")) {
            return new ResourceLocation(id);
        }
        return new ResourceLocation(namespace, id);
    }

    @Nullable
    public static <T> T findFirstInRegistry(Registry<T> registry, ResourceLocation ... id) {
        for (ResourceLocation r : id) {
            Optional optional = registry.m_6612_(r);
            if (!optional.isPresent()) continue;
            return optional.get();
        }
        return null;
    }
}

