/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import net.mehvahdjukaar.moonlight.api.resources.textures.TextureCollager;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.core.misc.McMetaFile;
import net.minecraft.class_2470;
import net.minecraft.class_5253;

public final class TextureOps {
    public static void grayscale(TextureImage img) {
        img.forEachPixel(pixel -> pixel.setValue(new RGBColor(pixel.getValue()).asHCL().withChroma(0.0f).asRGB().toInt()));
    }

    public static void applyOverlay(TextureImage img, TextureImage ... overlays) {
        TextureOps.applyOverlay(img, false, overlays);
    }

    public static void applyOverlayOnExisting(TextureImage img, TextureImage ... overlays) {
        TextureOps.applyOverlay(img, true, overlays);
    }

    private static void applyOverlay(TextureImage baseImage, boolean onlyOnExisting, TextureImage ... overlays) {
        int baseFrameWidth = baseImage.frameWidth();
        int baseFrameHeight = baseImage.frameHeight();
        for (TextureImage overlay : overlays) {
            if (overlay.frameWidth() < baseFrameWidth) {
                throw new IllegalStateException("Overlay width too small (overlay W: " + overlay.frameWidth() + ", base W: " + baseFrameWidth + ")");
            }
            if (overlay.frameHeight() >= baseFrameHeight) continue;
            throw new IllegalStateException("Overlay height too small (overlay H: " + overlay.frameHeight() + ", base H: " + baseFrameHeight + ")");
        }
        for (TextureImage overlay : overlays) {
            baseImage.forEachPixel(pixel -> {
                int frameX = pixel.frameX();
                int frameY = pixel.frameY();
                int overlayFrame = Math.min(pixel.frameIndex(), overlay.frameCount() - 1);
                int overlayPixel = overlay.getFramePixel(overlayFrame, frameX, frameY);
                if (onlyOnExisting && class_5253.class_8045.method_48342((int)overlayPixel) == 0) {
                    return;
                }
                pixel.blendValue(overlayPixel);
            });
        }
    }

    public static void makeOpaque(TextureImage img, int backgroundColor) {
        img.forEachPixel(pixel -> {
            int oldValue = pixel.getValue();
            int alpha = class_5253.class_8045.method_48342((int)oldValue);
            if (alpha == 0) {
                pixel.setValue(backgroundColor);
            } else {
                int newColor = class_5253.class_8045.method_48344((int)255, (int)class_5253.class_8045.method_48345((int)oldValue), (int)class_5253.class_8045.method_48346((int)oldValue), (int)class_5253.class_8045.method_48347((int)oldValue));
                pixel.setValue(newColor);
            }
        });
    }

    private static void applyMask(TextureImage img, TextureImage mask, boolean discardOpaque) {
        if (mask.imageWidth() < img.imageWidth() || mask.imageHeight() < img.imageHeight()) {
            throw new IllegalArgumentException("Mask must be at least as large as the image.");
        }
        img.forEachPixel(pixel -> {
            boolean maskOpaque;
            int maskPixel = mask.getPixel(pixel.x(), pixel.y());
            boolean bl = maskOpaque = class_5253.class_8045.method_48342((int)maskPixel) != 0;
            if (maskOpaque == discardOpaque) {
                pixel.setValue(0);
            }
        });
    }

    public static void applyMask(TextureImage img, TextureImage mask) {
        TextureOps.applyMask(img, mask, true);
    }

    public static void applyMaskInverted(TextureImage img, TextureImage mask) {
        TextureOps.applyMask(img, mask, false);
    }

    public static TextureImage createSingleFrameAnimation(TextureImage img, int length, McMetaFile animationData) {
        if (length <= 0) {
            throw new IllegalArgumentException("Length must be greater than 0");
        }
        McMetaFile newMetadata = animationData.cloneWithSize(img.frameWidth(), img.frameHeight());
        if (length == 1) {
            return img.makeCopyWithMetadata(newMetadata);
        }
        TextureImage newImage = TextureImage.createNew(img.frameWidth(), img.frameHeight() * length, newMetadata);
        newImage.forEachPixel(pixel -> {
            int xo = pixel.localX;
            int yo = pixel.localY;
            pixel.setValue(img.getFramePixel(0, xo, yo));
        });
        return newImage;
    }

    public static TextureImage createScaled(TextureImage img, float widthScale, float heightScale) {
        int newW = (int)((float)img.imageWidth() * widthScale);
        int newH = (int)((float)img.imageHeight() * heightScale);
        McMetaFile meta = null;
        McMetaFile metadata = img.getMcMeta();
        if (metadata != null) {
            int mW = (int)((float)metadata.animation().field_5338 * widthScale);
            int mH = (int)((float)metadata.animation().field_5336 * heightScale);
            meta = metadata.cloneWithSize(mW, mH);
        }
        TextureImage im = TextureImage.createNew(newW, newH, meta);
        TextureCollager transformer = TextureCollager.builder(img.frameWidth(), img.frameHeight(), im.frameWidth(), im.frameHeight()).copyFrom(0, 0, img.frameWidth(), img.frameHeight()).to(0, 0, im.frameWidth(), im.frameHeight()).build();
        transformer.apply(img, im);
        return im;
    }

    public static TextureImage createRotated(TextureImage img, class_2470 rotation) {
        TextureImage flippedImage = TextureImage.createNew(img.frameHeight(), img.frameWidth() * img.frameCount(), img.getMcMeta());
        img.forEachPixel(context -> {
            int frameX = context.frameX();
            int frameY = context.frameY();
            int frameIndex = context.frameIndex();
            int newFrameX = frameX;
            int newFrameY = frameY;
            int frameWidth = img.frameWidth();
            int frameHeight = img.frameHeight();
            if (rotation == class_2470.field_11463) {
                newFrameX = frameHeight - frameY - 1;
                newFrameY = frameX;
            } else if (rotation == class_2470.field_11464) {
                newFrameX = frameWidth - frameX - 1;
                newFrameY = frameHeight - frameY - 1;
            } else if (rotation == class_2470.field_11465) {
                newFrameX = frameY;
                newFrameY = frameWidth - frameX - 1;
            }
            int newGlobalX = flippedImage.getFrameStartX(frameIndex) + newFrameX;
            int newGlobalY = flippedImage.getFrameStartY(frameIndex) + newFrameY;
            int pixel = context.getValue();
            flippedImage.setPixel(newGlobalX, newGlobalY, pixel);
        });
        return flippedImage;
    }
}

