/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import org.jetbrains.annotations.NotNull;

public class ModLootConditions {
    public static final Supplier<LootItemConditionType> ICONDITION_LOOT_CONDITION = RegHelper.register(Moonlight.res("iconditions"), () -> new LootItemConditionType((Serializer)new IConditionLootCondition.ConditionSerializer()), Registry.f_122877_);
    public static final Supplier<LootItemConditionType> PATTERN_MATCH_CONDITION = RegHelper.register(Moonlight.res("loot_table_id_pattern"), () -> new LootItemConditionType((Serializer)new PatternMatchCondition.ConditionSerializer()), Registry.f_122877_);

    public static void register() {
    }

    public record PatternMatchCondition(List<Pattern> patterns) implements LootItemCondition
    {
        public boolean test(LootContext lootContext) {
            String id = lootContext.getQueriedLootTableId().toString();
            for (Pattern p : this.patterns) {
                if (id.equals(p.pattern())) {
                    return true;
                }
                if (!p.matcher(id).find()) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public LootItemConditionType m_7940_() {
            return ICONDITION_LOOT_CONDITION.get();
        }

        public record ConditionSerializer() implements Serializer<PatternMatchCondition>
        {
            public void serialize(@NotNull JsonObject json, @NotNull PatternMatchCondition value, @NotNull JsonSerializationContext context) {
                JsonArray ja = new JsonArray();
                for (Pattern c : value.patterns) {
                    ja.add(c.pattern());
                }
                json.add("matches", (JsonElement)ja);
            }

            @NotNull
            public PatternMatchCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
                JsonArray ja = GsonHelper.m_13933_((JsonObject)json, (String)"matches");
                ArrayList<Pattern> l = new ArrayList<Pattern>();
                for (JsonElement c : ja) {
                    l.add(Pattern.compile(c.getAsString()));
                }
                return new PatternMatchCondition(l);
            }
        }
    }

    public record IConditionLootCondition(List<ICondition> conditions) implements LootItemCondition
    {
        public boolean test(LootContext lootContext) {
            for (ICondition c : this.conditions) {
                if (c.test(ICondition.IContext.EMPTY)) continue;
                return false;
            }
            return true;
        }

        @NotNull
        public LootItemConditionType m_7940_() {
            return ICONDITION_LOOT_CONDITION.get();
        }

        public record ConditionSerializer() implements Serializer<IConditionLootCondition>
        {
            public void serialize(@NotNull JsonObject json, @NotNull IConditionLootCondition value, @NotNull JsonSerializationContext context) {
                JsonArray ja = new JsonArray();
                for (ICondition c : value.conditions) {
                    ja.add((JsonElement)CraftingHelper.serialize((ICondition)c));
                }
                json.add("values", (JsonElement)ja);
            }

            @NotNull
            public IConditionLootCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
                JsonArray ja = GsonHelper.m_13933_((JsonObject)json, (String)"values");
                ArrayList<ICondition> l = new ArrayList<ICondition>();
                for (JsonElement c : ja) {
                    if (!c.isJsonObject()) {
                        throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
                    }
                    l.add(CraftingHelper.getCondition((JsonObject)c.getAsJsonObject()));
                }
                return new IConditionLootCondition(l);
            }
        }
    }
}

