/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.loot_pool_entries;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.loot_pool_entries.ModLootPoolEntries;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryType;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import org.jetbrains.annotations.Nullable;

public class OptionalItemPool
extends LootPoolSingletonContainer {
    @Nullable
    private final Item item;
    private final String res;

    OptionalItemPool(String res, int i, int j, LootItemCondition[] lootItemConditions, LootItemFunction[] lootItemFunctions) {
        super(i, j, OptionalItemPool.disableIfInvalid(res, lootItemConditions), lootItemFunctions);
        this.item = OptionalItemPool.getOptional(res);
        this.res = res;
    }

    @Nullable
    private static Item getOptional(String res) {
        if (res.startsWith("#")) {
            TagKey key = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(res.substring(1)));
            Iterator iterator = Registry.f_122827_.m_206058_(key).iterator();
            if (iterator.hasNext()) {
                Holder v = (Holder)iterator.next();
                return (Item)v.m_203334_();
            }
            return null;
        }
        return Registry.f_122827_.m_6612_(new ResourceLocation(res)).orElse(null);
    }

    private static LootItemCondition[] disableIfInvalid(String res, LootItemCondition[] lootItemConditions) {
        if (OptionalItemPool.getOptional(res) == null) {
            ArrayList<LootItemCondition> newCond = new ArrayList<LootItemCondition>();
            newCond.add(LootItemRandomChanceCondition.m_81927_((float)0.0f).m_6409_());
            newCond.addAll(List.of(lootItemConditions));
            return newCond.toArray(new LootItemCondition[0]);
        }
        return lootItemConditions;
    }

    public LootPoolEntryType m_6751_() {
        return ModLootPoolEntries.LAZY_ITEM.get();
    }

    public void m_6948_(Consumer<ItemStack> stackConsumer, LootContext lootContext) {
        if (this.item != null) {
            stackConsumer.accept(new ItemStack((ItemLike)this.item));
        } else {
            Moonlight.LOGGER.warn("Tried to add an item from a disabled OptionalLootPoolEntry");
        }
    }

    public static LootPoolSingletonContainer.Builder<?> lootTableOptionalItem(String itemRes) {
        return OptionalItemPool.m_79687_((i, j, lootItemConditions, lootItemFunctions) -> new OptionalItemPool(itemRes, i, j, lootItemConditions, lootItemFunctions));
    }

    public static class Serializer
    extends LootPoolSingletonContainer.Serializer<OptionalItemPool> {
        public void serializeCustom(JsonObject object, OptionalItemPool context, JsonSerializationContext conditions) {
            super.m_7219_(object, (LootPoolSingletonContainer)context, conditions);
            object.addProperty("name", context.res.toString());
        }

        protected OptionalItemPool deserialize(JsonObject object, JsonDeserializationContext context, int weight, int quality, LootItemCondition[] conditions, LootItemFunction[] functions) {
            String item = Serializer.getItemLocation(object, "name");
            return new OptionalItemPool(item, weight, quality, conditions, functions);
        }

        private static String getItemLocation(JsonObject json, String memberName) {
            if (json.has(memberName)) {
                return GsonHelper.m_13906_((JsonObject)json, (String)memberName);
            }
            throw new JsonSyntaxException("Missing " + memberName + ", expected to find an item");
        }
    }
}

