/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.wood;

import com.google.common.base.Suppliers;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class WoodType
extends BlockType {
    public final Material material;
    public final Block planks;
    public final Block log;
    private final Supplier<net.minecraft.world.level.block.state.properties.WoodType> vanillaType = Suppliers.memoize(() -> {
        String i = this.id.m_135827_().equals("minecraft") ? this.id.m_135815_() : this.id.toString();
        Optional<net.minecraft.world.level.block.state.properties.WoodType> o = net.minecraft.world.level.block.state.properties.WoodType.m_61843_().filter(v -> v.m_61846_().equals(i)).findAny();
        return o.orElse(null);
    });

    protected WoodType(ResourceLocation id, Block baseBlock, Block logBlock) {
        super(id);
        this.planks = baseBlock;
        this.log = logBlock;
        this.material = baseBlock.m_49966_().m_60767_();
    }

    @Nullable
    protected Block findLogRelatedBlock(String prefix, String ... possibleNames) {
        for (String n : possibleNames) {
            Block b = this.findWithPrefix(prefix, n);
            if (b == null) continue;
            return b;
        }
        return null;
    }

    @Nullable
    protected Block findWithPrefix(String prefix, String postfix) {
        postfix = "_" + (String)postfix;
        prefix = ((String)prefix).isEmpty() ? "" : (String)prefix + "_";
        ResourceLocation id = this.getId();
        String logN = Utils.getID(this.log).m_135815_();
        ResourceLocation[] targets = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), logN + "_" + (String)prefix + (String)postfix), new ResourceLocation(id.m_135827_(), (String)prefix + logN + (String)postfix), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_" + (String)prefix + (String)postfix), new ResourceLocation(id.m_135827_(), (String)prefix + id.m_135815_() + (String)postfix)};
        Block found = null;
        for (ResourceLocation r : targets) {
            if (!Registry.f_122824_.m_7804_(r)) continue;
            found = (Block)Registry.f_122824_.m_7745_(r);
            break;
        }
        return found;
    }

    public Material getMaterial() {
        return this.material;
    }

    @Override
    public ItemLike mainChild() {
        return this.planks;
    }

    @Nullable
    public net.minecraft.world.level.block.state.properties.WoodType toVanilla() {
        return this.vanillaType.get();
    }

    public String getTexturePath() {
        String namespace = this.getNamespace();
        if (namespace.equals("minecraft")) {
            return this.getTypeName();
        }
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public boolean canBurn() {
        return this.material.m_76335_();
    }

    public MaterialColor getColor() {
        return this.material.m_76339_();
    }

    @Override
    public String getTranslationKey() {
        return "wood_type." + this.getNamespace() + "." + this.getTypeName();
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", (ItemLike)this.planks);
        this.addChild("log", (ItemLike)this.log);
        this.addChild("leaves", (ItemLike)this.findRelatedEntry("leaves", Registry.f_122824_));
        this.addChild("stripped_log", (ItemLike)this.findLogRelatedBlock("stripped", "log", "stem", "stalk"));
        this.addChild("stripped_wood", (ItemLike)this.findLogRelatedBlock("stripped", "wood", "hyphae"));
        this.addChild("wood", (ItemLike)this.findLogRelatedBlock("", "wood", "hyphae"));
        this.addChild("slab", (ItemLike)this.findRelatedEntry("slab", Registry.f_122824_));
        this.addChild("stairs", (ItemLike)this.findRelatedEntry("stairs", Registry.f_122824_));
        this.addChild("fence", (ItemLike)this.findRelatedEntry("fence", Registry.f_122824_));
        this.addChild("fence_gate", (ItemLike)this.findRelatedEntry("fence_gate", Registry.f_122824_));
        this.addChild("door", (ItemLike)this.findRelatedEntry("door", Registry.f_122824_));
        this.addChild("trapdoor", (ItemLike)this.findRelatedEntry("trapdoor", Registry.f_122824_));
        this.addChild("button", (ItemLike)this.findRelatedEntry("button", Registry.f_122824_));
        this.addChild("pressure_plate", (ItemLike)this.findRelatedEntry("pressure_plate", Registry.f_122824_));
        this.addChild("hanging_sign", (ItemLike)this.findRelatedEntry("hanging_sign", Registry.f_122824_));
        this.addChild("wall_hanging_sign", (ItemLike)this.findRelatedEntry("wall_hanging_sign", Registry.f_122824_));
        this.addChild("sign", (ItemLike)this.findRelatedEntry("sign", Registry.f_122824_));
        this.addChild("sapling", (ItemLike)this.findRelatedEntry("sapling", Registry.f_122824_));
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", Registry.f_122827_));
        this.addChild("sign", this.findRelatedEntry("sign", Registry.f_122827_));
    }

    public static class Finder
    implements BlockType.SetFinder<WoodType> {
        private final Map<String, ResourceLocation> childNames = new HashMap<String, ResourceLocation>();
        private final Supplier<Block> planksFinder;
        private final Supplier<Block> logFinder;
        private final ResourceLocation id;

        public Finder(ResourceLocation id, Supplier<Block> planks, Supplier<Block> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(new ResourceLocation(modId, woodTypeName), new ResourceLocation(modId, planksName), new ResourceLocation(modId, logName));
        }

        public static Finder simple(ResourceLocation woodTypeName, ResourceLocation planksName, ResourceLocation logName) {
            return new Finder(woodTypeName, () -> (Block)Registry.f_122824_.m_7745_(planksName), () -> (Block)Registry.f_122824_.m_7745_(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, new ResourceLocation(this.id.m_135827_(), childName));
        }

        public void addChild(String childType, ResourceLocation childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        @ApiStatus.Internal
        public Optional<WoodType> get() {
            if (PlatformHelper.isModLoaded(this.id.m_135827_())) {
                try {
                    Block plank = this.planksFinder.get();
                    Block log = this.logFinder.get();
                    Block d = (Block)Registry.f_122824_.m_7745_(Registry.f_122824_.m_122315_());
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodType w = new WoodType(this.id, plank, log);
                        this.childNames.forEach((key, value) -> w.addChild((String)key, Registry.f_122824_.m_7745_(value)));
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Moonlight.LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

