/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidRegistryImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidClient;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidRegistry {
    public static final ResourceLocation EMPTY_ID = Moonlight.res("empty");

    public static SoftFluid getEmpty() {
        return SoftFluidRegistry.get(EMPTY_ID);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidRegistryImpl.init();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ResourceKey<Registry<SoftFluid>> getRegistryKey() {
        return SoftFluidRegistryImpl.getRegistryKey();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<Fluid, SoftFluid> getFluidsMap() {
        return SoftFluidRegistryImpl.getFluidsMap();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<Item, SoftFluid> getItemsMap() {
        return SoftFluidRegistryImpl.getItemsMap();
    }

    public static Registry<SoftFluid> getDataPackRegistry() {
        return SoftFluidRegistry.getDataPackRegistry(Utils.hackyGetRegistryAccess());
    }

    public static Registry<SoftFluid> getDataPackRegistry(RegistryAccess registryAccess) {
        return registryAccess.m_175515_(SoftFluidRegistry.getRegistryKey());
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.getDataPackRegistry().m_123024_().toList();
    }

    public static Set<Map.Entry<ResourceKey<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.getDataPackRegistry().m_6579_();
    }

    public static SoftFluid get(String id) {
        return SoftFluidRegistry.get(new ResourceLocation(id));
    }

    @Nullable
    public static ResourceLocation getID(SoftFluid s) {
        return SoftFluidRegistry.getDataPackRegistry().m_7981_((Object)s);
    }

    public static SoftFluid get(ResourceLocation id) {
        SoftFluid r;
        String namespace = id.m_135827_();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.m_135815_());
        }
        if ((r = (SoftFluid)SoftFluidRegistry.getDataPackRegistry().m_7745_(id)) == null) {
            return (SoftFluid)SoftFluidRegistry.getDataPackRegistry().m_7745_(EMPTY_ID);
        }
        return r;
    }

    public static Optional<SoftFluid> getOptional(ResourceLocation id) {
        String namespace = id.m_135827_();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.m_135815_());
        }
        return SoftFluidRegistry.getDataPackRegistry().m_6612_(id);
    }

    public static SoftFluid fromVanillaFluid(Fluid fluid) {
        return SoftFluidRegistry.getFluidsMap().getOrDefault(fluid, SoftFluidRegistry.getEmpty());
    }

    @Deprecated(forRemoval=true)
    public static SoftFluid fromForgeFluid(Fluid fluid) {
        return SoftFluidRegistry.fromVanillaFluid(fluid);
    }

    @NotNull
    public static SoftFluid fromItem(Item filledContainerItem) {
        return SoftFluidRegistry.getItemsMap().getOrDefault(filledContainerItem, SoftFluidRegistry.getEmpty());
    }

    private static void populateSlaveMaps() {
        Map<Item, SoftFluid> itemMap = SoftFluidRegistry.getItemsMap();
        itemMap.clear();
        Map<Fluid, SoftFluid> fluidsMap = SoftFluidRegistry.getFluidsMap();
        fluidsMap.clear();
        for (SoftFluid s : SoftFluidRegistry.getValues()) {
            if (!PlatformHelper.isModLoaded(s.getFromMod())) continue;
            s.getEquivalentFluids().forEach(f -> fluidsMap.put((Fluid)f, s));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != Items.f_42589_ || s != VanillaSoftFluids.WATER.get()) {
                    itemMap.put((Item)i, s);
                }
            });
        }
    }

    @ApiStatus.Internal
    public static void postInitClient() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidClient.refresh();
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(ServerPlayer player, boolean o) {
        ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
    }

    @ApiStatus.Internal
    public static void onDataLoad() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidRegistry.registerExistingVanillaFluids();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids() {
        SoftFluidRegistryImpl.registerExistingVanillaFluids();
    }
}

