/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.fluids.FluidContainerList;
import net.mehvahdjukaar.moonlight.api.fluids.FoodProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.forge.SoftFluidImpl;
import net.mehvahdjukaar.moonlight.api.misc.Triplet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SoftFluid {
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    private final String fromMod;
    private final String translationKey;
    private final int luminosity;
    private final int tintColor;
    private final TintMethod tintMethod;
    private final List<Fluid> equivalentFluids;
    private final FluidContainerList containerList;
    private final FoodProvider food;
    private final List<String> NBTFromItem;
    @Nullable
    private final ResourceLocation useTexturesFrom;
    public final boolean isGenerated;
    private final Supplier<ResourceLocation> cachedID = Suppliers.memoize(() -> SoftFluidRegistry.getID(this));
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;
    public static final Codec<Holder<SoftFluid>> HOLDER_CODEC = RegistryFileCodec.m_135589_(SoftFluidRegistry.getRegistryKey(), CODEC);
    public static final Codec<SoftFluid> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("still_texture").forGetter(SoftFluid::getStillTexture), (App)ResourceLocation.f_135803_.fieldOf("flowing_texture").forGetter(SoftFluid::getFlowingTexture), (App)Codec.STRING.optionalFieldOf("from_mod").forGetter(SoftFluid.getHackyOptional(SoftFluid::getFromMod)), (App)Codec.STRING.optionalFieldOf("translation_key").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTranslationKey)), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("luminosity").forGetter(SoftFluid.getHackyOptional(SoftFluid::getLuminosity)), (App)BaseColor.CODEC.optionalFieldOf("color").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintColor)), (App)TintMethod.CODEC.optionalFieldOf("tint_method").forGetter(SoftFluid.getHackyOptional(SoftFluid::getTintMethod)), (App)FoodProvider.CODEC.optionalFieldOf("food").forGetter(SoftFluid.getHackyOptional(SoftFluid::getFoodProvider)), (App)Codec.STRING.listOf().optionalFieldOf("preserved_tags_from_item").forGetter(SoftFluid.getHackyOptional(SoftFluid::getNbtKeyFromItem)), (App)FluidContainerList.Category.CODEC.listOf().optionalFieldOf("containers").forGetter(f -> f.getContainerList().encodeList()), (App)Registry.f_122822_.m_194605_().listOf().optionalFieldOf("equivalent_fluids").forGetter(SoftFluid.getHackyOptional(s -> s.getEquivalentFluids().stream().toList())), (App)ResourceLocation.f_135803_.optionalFieldOf("use_texture_from").forGetter(s -> Optional.ofNullable(s.getTextureOverride()))).apply((Applicative)instance, SoftFluid::create));
    private static final SoftFluid DEFAULT_DUMMY = new SoftFluid(new Builder(new ResourceLocation(""), new ResourceLocation("")));

    private SoftFluid(Builder builder) {
        Triplet<ResourceLocation, ResourceLocation, Integer> data;
        this.tintMethod = builder.tintMethod;
        this.equivalentFluids = builder.equivalentFluids;
        this.luminosity = builder.luminosity;
        this.containerList = builder.containerList;
        this.food = builder.food;
        this.fromMod = builder.fromMod;
        this.translationKey = builder.translationKey;
        this.NBTFromItem = builder.NBTFromItem;
        this.useTexturesFrom = builder.useTexturesFrom;
        ResourceLocation still = builder.stillTexture;
        ResourceLocation flowing = builder.flowingTexture;
        int tint = builder.tintColor;
        if (this.useTexturesFrom != null && (data = SoftFluid.getRenderingData(this.useTexturesFrom)) != null) {
            still = data.left();
            flowing = data.middle();
            tint = data.right();
        }
        this.stillTexture = still;
        this.flowingTexture = flowing;
        this.tintColor = tint;
        this.isGenerated = builder.isFromData;
    }

    @Deprecated
    public ResourceLocation getRegistryName() {
        return this.cachedID.get();
    }

    @Nullable
    public ResourceLocation getTextureOverride() {
        return this.useTexturesFrom;
    }

    public FoodProvider getFoodProvider() {
        return this.food;
    }

    public Component getTranslatedName() {
        return Component.m_237115_((String)this.translationKey);
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public String getFromMod() {
        return this.fromMod;
    }

    public Fluid getForgeFluid() {
        Iterator<Fluid> iterator = this.getEquivalentFluids().iterator();
        if (iterator.hasNext()) {
            Fluid fluid = iterator.next();
            return fluid;
        }
        return Fluids.f_76191_;
    }

    public List<String> getNbtKeyFromItem() {
        return this.NBTFromItem;
    }

    public List<Fluid> getEquivalentFluids() {
        return this.equivalentFluids;
    }

    public boolean isEquivalent(Fluid fluid) {
        return this.equivalentFluids.contains(fluid);
    }

    public boolean isEmpty() {
        return this == SoftFluidRegistry.getEmpty();
    }

    public Optional<Item> getFilledContainer(Item emptyContainer) {
        return this.containerList.getFilled(emptyContainer);
    }

    public Optional<Item> getEmptyContainer(Item filledContainer) {
        return this.containerList.getEmpty(filledContainer);
    }

    public FluidContainerList getContainerList() {
        return this.containerList;
    }

    public int getLuminosity() {
        return this.luminosity;
    }

    public int getTintColor() {
        return this.tintColor;
    }

    public TintMethod getTintMethod() {
        return this.tintMethod;
    }

    public boolean isColored() {
        return this.tintColor != -1;
    }

    public ResourceLocation getFlowingTexture() {
        return this.flowingTexture;
    }

    public ResourceLocation getStillTexture() {
        return this.stillTexture;
    }

    public boolean isFood() {
        return !this.food.isEmpty();
    }

    protected static SoftFluid create(ResourceLocation still, ResourceLocation flowing, Optional<String> fromMod, Optional<String> translation, Optional<Integer> luminosity, Optional<Integer> color, Optional<TintMethod> tint, Optional<FoodProvider> food, Optional<List<String>> nbtKeys, Optional<List<FluidContainerList.Category>> containers, Optional<List<Fluid>> equivalent, Optional<ResourceLocation> textureFrom) {
        Builder builder = new Builder(still, flowing);
        fromMod.ifPresent(builder::fromMod);
        translation.ifPresent(builder::translationKey);
        luminosity.ifPresent(builder::luminosity);
        color.ifPresent(builder::color);
        tint.ifPresent(builder::tintMethod);
        food.ifPresent(builder::food);
        nbtKeys.ifPresent(k -> k.forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0)));
        containers.ifPresent(b -> builder.containers(new FluidContainerList((List<FluidContainerList.Category>)b)));
        equivalent.ifPresent(e -> e.forEach(builder::addEqFluid));
        textureFrom.ifPresent(builder::copyTexturesFrom);
        return builder.build();
    }

    protected static SoftFluid merge(SoftFluid originalFluid, SoftFluid newFluid) {
        Builder builder = new Builder(newFluid.stillTexture, newFluid.flowingTexture);
        builder.translationKey(newFluid.getTranslationKey());
        builder.luminosity(newFluid.getLuminosity());
        builder.color(newFluid.getTintColor());
        builder.tintMethod(newFluid.getTintMethod());
        newFluid.getNbtKeyFromItem().forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0));
        originalFluid.getNbtKeyFromItem().forEach(xva$0 -> builder.keepNBTFromItem((String)xva$0));
        FluidContainerList containerList = newFluid.getContainerList();
        containerList.merge(originalFluid.getContainerList());
        builder.containers(containerList);
        newFluid.getEquivalentFluids().forEach(builder::addEqFluid);
        originalFluid.getEquivalentFluids().forEach(builder::addEqFluid);
        if (originalFluid.useTexturesFrom != null) {
            builder.copyTexturesFrom(originalFluid.useTexturesFrom);
        }
        if (newFluid.useTexturesFrom != null) {
            builder.copyTexturesFrom(newFluid.useTexturesFrom);
        }
        return builder.build();
    }

    private static <T> Function<SoftFluid, Optional<T>> getHackyOptional(Function<SoftFluid, T> getter) {
        return f -> {
            Object value = getter.apply((SoftFluid)f);
            Object def = getter.apply(DEFAULT_DUMMY);
            return value == null || value.equals(def) ? Optional.empty() : Optional.of(value);
        };
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addFluidSpecificAttributes(Builder builder, Fluid fluid) {
        void var1_1;
        SoftFluidImpl.addFluidSpecificAttributes(builder, (Fluid)var1_1);
    }

    @ApiStatus.Internal
    @Nullable
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Triplet<ResourceLocation, ResourceLocation, Integer> getRenderingData(ResourceLocation useTexturesFrom) {
        return SoftFluidImpl.getRenderingData(useTexturesFrom);
    }

    public static class Builder {
        private ResourceLocation stillTexture;
        private ResourceLocation flowingTexture;
        private String fromMod = "minecraft";
        private String translationKey = "fluid.selene.generic_fluid";
        private int luminosity = 0;
        private int tintColor = -1;
        private TintMethod tintMethod = TintMethod.STILL_AND_FLOWING;
        private FoodProvider food = FoodProvider.EMPTY;
        private FluidContainerList containerList = new FluidContainerList();
        private final List<String> NBTFromItem = new ArrayList<String>();
        private final List<Fluid> equivalentFluids = new ArrayList<Fluid>();
        public boolean isFromData = true;
        private ResourceLocation useTexturesFrom;

        public Builder(ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
        }

        public Builder(Fluid fluid) {
            this(new ResourceLocation("block/water_still"), new ResourceLocation("minecraft:block/water_flowing"));
            this.copyTexturesFrom(Utils.getID(fluid));
            this.addEqFluid(fluid);
            this.isFromData = false;
            SoftFluid.addFluidSpecificAttributes(this, fluid);
        }

        public final Builder textures(ResourceLocation still, ResourceLocation flow) {
            this.stillTexture = still;
            this.flowingTexture = flow;
            return this;
        }

        public final Builder translationKey(String translationKey) {
            if (translationKey != null) {
                this.translationKey = translationKey;
            }
            return this;
        }

        public final Builder keepNBTFromItem(String ... NBTkey) {
            this.NBTFromItem.addAll(Arrays.asList(NBTkey));
            return this;
        }

        public final Builder color(int tintColor) {
            this.tintColor = tintColor;
            return this;
        }

        public final Builder noTint() {
            this.tintMethod = TintMethod.NO_TINT;
            return this;
        }

        public final Builder tinted() {
            this.tintMethod = TintMethod.STILL_AND_FLOWING;
            return this;
        }

        public final Builder onlyFlowingTinted() {
            this.tintMethod = TintMethod.FLOWING;
            return this;
        }

        public final Builder tintMethod(TintMethod tint) {
            this.tintMethod = tint;
            return this;
        }

        public final Builder luminosity(int luminosity) {
            this.luminosity = luminosity;
            return this;
        }

        public final Builder addEqFluid(Fluid fluid) {
            if (fluid != null && fluid != Fluids.f_76191_) {
                this.equivalentFluids.add(fluid);
                Item i = fluid.m_6859_();
                if (i != Items.f_41852_ && i != Items.f_42446_) {
                    this.bucket(i);
                }
            }
            return this;
        }

        public final Builder copyTexturesFrom(ResourceLocation fluidRes) {
            this.useTexturesFrom = fluidRes;
            return this;
        }

        public final Builder copyTexturesFrom(String fluidRes) {
            return this.copyTexturesFrom(new ResourceLocation(fluidRes));
        }

        public final Builder containerItem(Item filledItem, Item emptyItem, int itemCapacity) {
            if (filledItem != Items.f_41852_) {
                this.containerList.add(emptyItem, filledItem, itemCapacity);
            }
            return this;
        }

        public final Builder containerItem(Item filledItem, Item emptyItem, int itemCapacity, SoundEvent fillSound, SoundEvent emptySound) {
            if (filledItem != Items.f_41852_) {
                this.containerList.add(emptyItem, filledItem, itemCapacity, fillSound, emptySound);
            }
            return this;
        }

        public final Builder containers(FluidContainerList containerList) {
            this.containerList = containerList;
            return this;
        }

        public final Builder emptyHandContainerItem(Item filledItem, int itemCapacity) {
            if (filledItem != Items.f_41852_) {
                return this.containerItem(filledItem, Items.f_41852_, itemCapacity);
            }
            return this;
        }

        public final Builder bottle(Item item) {
            this.containerItem(item, Items.f_42590_, 1);
            return this;
        }

        public final Builder drink(Item item) {
            return this.bottle(item).food(item, 1);
        }

        public final Builder bucket(Item item) {
            this.containerItem(item, Items.f_42446_, 4, SoundEvents.f_11781_, SoundEvents.f_11778_);
            return this;
        }

        public final Builder bowl(Item item) {
            this.containerItem(item, Items.f_42399_, 2);
            return this;
        }

        public final Builder stew(Item item) {
            return this.bowl(item).food(item, 2);
        }

        public final Builder food(Item item) {
            return this.food(item, 1);
        }

        public final Builder food(Item item, int foodDivider) {
            if (item != null) {
                this.food(FoodProvider.create(item, foodDivider));
            }
            return this;
        }

        public final Builder food(FoodProvider foodProvider) {
            this.food = foodProvider;
            return this;
        }

        public SoftFluid build() {
            return new SoftFluid(this);
        }

        public final Builder fromMod(String s) {
            this.fromMod = s;
            return this;
        }
    }

    public static enum TintMethod implements StringRepresentable
    {
        NO_TINT,
        FLOWING,
        STILL_AND_FLOWING;

        public static final Codec<TintMethod> CODEC;

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.m_216439_(TintMethod::values);
        }
    }
}

