/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_746;

public class AntiRepostWarning {
    private static final Set<String> MODS = new HashSet<String>();

    public static void addMod(String id) {
        if (!Objects.equals(id, "minecraft")) {
            MODS.add(id);
        }
    }

    public static void run() {
        if (PlatformHelper.isDev()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        Set reposted = MODS.stream().filter(AntiRepostWarning::isFileNameSus).collect(Collectors.toSet());
        try {
            for (String m : reposted) {
                String url = PlatformHelper.getModPageUrl(m);
                if (url == null) {
                    url = "https://curseforge.com/minecraft/mc-mods";
                }
                class_5250 link = class_2561.method_43471((String)"message.moonlight.anti_repost_link");
                String modName = PlatformHelper.getModName(m);
                class_5250 name = class_2561.method_43470((String)modName).method_27692(class_124.field_1067);
                class_2558 click = new class_2558(class_2558.class_2559.field_11749, url);
                link.method_10862(link.method_10866().method_10958(click).method_30938(Boolean.valueOf(true)).method_27703(class_5251.method_27718((class_124)class_124.field_1065)));
                player.method_7353((class_2561)class_2561.method_43469((String)"message.moonlight.anti_repost", (Object[])new Object[]{name, link}), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isFileNameSus(String mod) {
        Path path = PlatformHelper.getModFilePath(mod);
        if (path == null || path.getFileName() == null) {
            Moonlight.LOGGER.warn("Failed to get file path of mod {}", (Object)mod);
        } else {
            String fileName = path.getFileName().toString();
            if (fileName.contains(".jar")) {
                return fileName.contains("-Mod-") || fileName.endsWith("-tw");
            }
        }
        return false;
    }
}

