/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final BiMap<String, Object> children = HashBiMap.create();
    public final class_2960 id;

    protected BlockType(class_2960 resourceLocation) {
        this.id = resourceLocation;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.method_12832();
    }

    public String getNamespace() {
        return this.id.method_12836();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, class_2378<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, class_2378<V> reg) {
        Optional o;
        if (this.id.method_12836().equals("tfc") && (o = reg.method_17966(new class_2960(this.id.method_12836(), "wood/" + postPend + "/" + this.id.method_12832()))).isPresent()) {
            return (V)o.get();
        }
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        class_2960[] targets = new class_2960[]{new class_2960(this.id.method_12836(), this.id.method_12832() + "_" + append + (String)post), new class_2960(this.id.method_12836(), append + "_" + this.id.method_12832() + (String)post), new class_2960(this.id.method_12836(), this.id.method_12832() + "_planks_" + append + (String)post)};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_10223(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, Object>> getChildren() {
        return this.children.entrySet();
    }

    @Nullable
    public class_1792 getItemOfThis(String key) {
        class_1792 class_17922;
        Object v = this.getChild(key);
        if (v instanceof class_1935) {
            class_1935 i = (class_1935)v;
            class_17922 = i.method_8389();
        } else {
            class_17922 = null;
        }
        return class_17922;
    }

    @Nullable
    public class_2248 getBlockOfThis(String key) {
        class_2248 b;
        Object v = this.getChild(key);
        if (v instanceof class_1747) {
            class_1747 bi = (class_1747)v;
            return bi.method_7711();
        }
        return v instanceof class_2248 ? (b = (class_2248)v) : null;
    }

    @Nullable
    public Object getChild(String key) {
        return this.children.get((Object)key);
    }

    @Deprecated(forRemoval=true)
    public void addChild(String genericName, @Nullable class_1935 itemLike) {
        this.addChild(genericName, (Object)itemLike);
    }

    public void addChild(String genericName, @Nullable Object itemLike) {
        if (itemLike != null) {
            this.children.put((Object)genericName, itemLike);
            BlockTypeRegistry<?> v = BlockSetInternal.getRegistry(this.getClass());
            if (v != null) {
                v.mapObjectToType(itemLike, this);
            }
        }
    }

    @ApiStatus.Internal
    public abstract void initializeChildrenBlocks();

    @ApiStatus.Internal
    public abstract void initializeChildrenItems();

    public abstract class_1935 mainChild();

    @Nullable
    public String getChildKey(Object child) {
        return (String)this.children.inverse().get(child);
    }

    @Nullable
    public static Object changeType(Object current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        String key = originalMat.getChildKey(current);
        if (key != null) {
            return destinationMat.getChild(key);
        }
        return null;
    }

    @Nullable
    public static class_1792 changeItemType(class_1792 current, BlockType originalMat, BlockType destinationMat) {
        class_2248 il;
        class_1792 i;
        class_1747 bi;
        Object blockChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current instanceof class_1747 && (blockChanged = BlockType.changeType((bi = (class_1747)current).method_7711(), originalMat, destinationMat)) instanceof class_2248 && (i = (il = (class_2248)blockChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_1935) {
            class_1935 il2 = (class_1935)changed;
            return il2.method_8389();
        }
        return null;
    }

    @Nullable
    public static class_2248 changeBlockType(@NotNull class_2248 current, BlockType originalMat, BlockType destinationMat) {
        class_1747 bi;
        class_1792 i;
        Object itemChanged;
        Object changed = BlockType.changeType(current, originalMat, destinationMat);
        if (changed == null && current.method_8389() != class_1802.field_8162 && (itemChanged = BlockType.changeType(current.method_8389(), originalMat, destinationMat)) instanceof class_1747 && (i = (bi = (class_1747)itemChanged).method_8389()) != class_1802.field_8162) {
            changed = i;
        }
        if (changed instanceof class_2248) {
            class_2248 b = (class_2248)changed;
            return b;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public static class_1935 changeItemBlockType(class_1935 current, BlockType originalMat, BlockType destinationMat) {
        Object v = BlockType.changeType(current, originalMat, destinationMat);
        if (v instanceof class_1935) {
            class_1935 il = (class_1935)v;
            return il;
        }
        return null;
    }

    @FunctionalInterface
    public static interface SetFinder<T extends BlockType>
    extends Supplier<Optional<T>> {
        @Override
        public Optional<T> get();
    }
}

