/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.minecraft.class_1011;
import net.minecraft.class_1079;
import org.jetbrains.annotations.Nullable;

public class Respriter {
    private final TextureImage imageToRecolor;
    private final List<Palette> originalPalettes;

    public static Respriter of(TextureImage imageToRecolor) {
        return new Respriter(imageToRecolor, Palette.fromAnimatedImage(imageToRecolor, null, 0.0f));
    }

    public static Respriter masked(TextureImage imageToRecolor, TextureImage colorMask) {
        return new Respriter(imageToRecolor, Palette.fromAnimatedImage(imageToRecolor, colorMask, 0.0f));
    }

    public static Respriter ofPalette(TextureImage imageToRecolor, List<Palette> colorsToSwap) {
        return new Respriter(imageToRecolor, colorsToSwap);
    }

    public static Respriter ofPalette(TextureImage imageToRecolor, Palette colorsToSwap) {
        return new Respriter(imageToRecolor, List.of(colorsToSwap));
    }

    private Respriter(TextureImage imageToRecolor, List<Palette> colorsToSwap) {
        if (colorsToSwap.size() == 0) {
            throw new UnsupportedOperationException("Respriter must have a non empty target palette");
        }
        if (imageToRecolor.framesSize() > colorsToSwap.size()) {
            Palette firstPalette = colorsToSwap.get(0);
            for (int i = 0; i < imageToRecolor.framesSize(); ++i) {
                colorsToSwap.set(i, firstPalette);
            }
        }
        this.imageToRecolor = imageToRecolor;
        this.originalPalettes = colorsToSwap;
    }

    public TextureImage recolorWithAnimationOf(TextureImage textureImage) {
        return this.recolorWithAnimation(Palette.fromAnimatedImage(textureImage), textureImage.getMetadata());
    }

    public TextureImage recolorWithAnimation(List<Palette> targetPalettes, @Nullable class_1079 targetAnimationData) {
        if (targetAnimationData == null) {
            return this.recolor(targetPalettes);
        }
        Palette originalPalette = this.originalPalettes.get(0);
        TextureImage texture = this.imageToRecolor.createAnimationTemplate(targetPalettes.size(), targetAnimationData);
        class_1011 img = texture.getImage();
        HashMap mapForFrameCache = new HashMap();
        texture.forEachFrame((ind, x, y) -> {
            Integer oldValue;
            Integer newValue;
            ColorToColorMap oldToNewMap = mapForFrameCache.computeIfAbsent(ind, i -> {
                Palette toPalette = (Palette)targetPalettes.get(ind);
                return ColorToColorMap.create(originalPalette, toPalette);
            });
            if (oldToNewMap != null && (newValue = oldToNewMap.mapColor(oldValue = Integer.valueOf(img.method_4315(x.intValue(), y.intValue())))) != null) {
                img.method_4305(x.intValue(), y.intValue(), newValue.intValue());
            }
        });
        return texture;
    }

    public TextureImage recolor(Palette targetPalette) {
        return this.recolor(List.of(targetPalette));
    }

    public TextureImage recolor(List<Palette> targetPalettes) {
        boolean onlyUseFirst = targetPalettes.size() < this.originalPalettes.size();
        TextureImage texture = this.imageToRecolor.makeCopy();
        class_1011 img = texture.getImage();
        HashMap mapForFrameCache = new HashMap();
        texture.forEachFrame((ind, x, y) -> {
            Integer oldValue;
            Integer newValue;
            ColorToColorMap oldToNewMap = mapForFrameCache.computeIfAbsent(ind, i -> {
                Palette toPalette = onlyUseFirst ? (Palette)targetPalettes.get(0) : (Palette)targetPalettes.get(ind);
                Palette originalPalette = this.originalPalettes.get(ind);
                return ColorToColorMap.create(originalPalette, toPalette);
            });
            if (oldToNewMap != null && (newValue = oldToNewMap.mapColor(oldValue = Integer.valueOf(img.method_4315(x.intValue(), y.intValue())))) != null) {
                img.method_4305(x.intValue(), y.intValue(), newValue.intValue());
            }
        });
        return texture;
    }

    public record ColorToColorMap(Map<Integer, Integer> map) {
        @Nullable
        public Integer mapColor(Integer color) {
            return this.map.get(color);
        }

        @Nullable
        public static ColorToColorMap create(Palette originalPalette, Palette toPalette) {
            Palette copy = toPalette.copy();
            copy.matchSize(originalPalette.size(), Float.valueOf(originalPalette.getAverageLuminanceStep()));
            if (copy.size() != originalPalette.size()) {
                return null;
            }
            return new ColorToColorMap(ColorToColorMap.zipToMap(originalPalette.getValues(), copy.getValues()));
        }

        private static Map<Integer, Integer> zipToMap(List<PaletteColor> keys, List<PaletteColor> values) {
            return IntStream.range(0, keys.size()).boxed().collect(Collectors.toMap(i -> ((PaletteColor)keys.get((int)i)).value(), i -> ((PaletteColor)values.get((int)i)).value()));
        }
    }
}

