/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.MapDecorationRegistry;
import net.mehvahdjukaar.moonlight.api.map.markers.MapBlockMarker;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomDecorationType<D extends CustomMapDecoration, M extends MapBlockMarker<D>>
implements MapDecorationType<D, M> {
    public static final Codec<CustomDecorationType<?, ?>> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("custom_type").forGetter(MapDecorationType::getCustomFactoryID)).apply((Applicative)instance, MapDecorationRegistry::getCustomType));
    private final class_2960 id;
    private final BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory;
    @NotNull
    private final Supplier<M> markerFactory;
    @Nullable
    private final BiFunction<class_1922, class_2338, M> markerFromWorldFactory;

    private CustomDecorationType(class_2960 typeId, BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory, Supplier<M> markerFactory, @Nullable BiFunction<class_1922, class_2338, M> markerFromWorldFactory) {
        this.id = typeId;
        this.markerFactory = markerFactory;
        this.markerFromWorldFactory = markerFromWorldFactory;
        this.decorationFactory = decorationFactory;
    }

    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> withWorldMarker(class_2960 typeId, Supplier<M> markerFactory, @Nullable BiFunction<class_1922, class_2338, M> markerFromWorldFactory, BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory) {
        return new CustomDecorationType<D, M>(typeId, decorationFactory, markerFactory, markerFromWorldFactory);
    }

    public static <D extends CustomMapDecoration, M extends MapBlockMarker<D>> CustomDecorationType<D, M> simple(class_2960 typeId, Supplier<M> markerFactory, BiFunction<MapDecorationType<?, ?>, class_2540, D> decorationFactory) {
        return new CustomDecorationType<D, M>(typeId, decorationFactory, markerFactory, null);
    }

    @Override
    public class_2960 getCustomFactoryID() {
        return this.id;
    }

    @Override
    public boolean isFromWorld() {
        return this.markerFromWorldFactory != null;
    }

    @Override
    @Nullable
    public D loadDecorationFromBuffer(class_2540 buffer) {
        try {
            return (D)((CustomMapDecoration)this.decorationFactory.apply(this, buffer));
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load custom map decoration for decoration type" + this + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public M loadMarkerFromNBT(class_2487 compound) {
        MapBlockMarker marker = (MapBlockMarker)this.markerFactory.get();
        try {
            marker.loadFromNBT(compound);
            return (M)marker;
        }
        catch (Exception e) {
            Moonlight.LOGGER.warn("Failed to load world map marker for decoration type" + this + ": " + e);
            return null;
        }
    }

    @Override
    @Nullable
    public M getWorldMarkerFromWorld(class_1922 reader, class_2338 pos) {
        return (M)(this.markerFromWorldFactory != null ? (MapBlockMarker)this.markerFromWorldFactory.apply(reader, pos) : null);
    }

    @Override
    public M createEmptyMarker() {
        return (M)((MapBlockMarker)this.markerFactory.get());
    }
}

