/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.map.ExpandedMapData;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_22;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CustomMapData<H extends DirtyCounter> {
    public Type<?> getType();

    default public boolean persistOnCopyOrLock() {
        return true;
    }

    default public boolean onItemUpdate(class_22 data, class_1297 entity) {
        return false;
    }

    @Nullable
    default public class_2561 onItemTooltip(class_22 data, class_1799 stack) {
        return null;
    }

    public H createDirtyCounter();

    public void load(class_2487 var1);

    public void loadUpdateTag(class_2487 var1);

    public void save(class_2487 var1);

    public void saveToUpdateTag(class_2487 var1, H var2);

    default public void setDirty(class_22 data, Consumer<H> dirtySetter) {
        Type<?> type = this.getType();
        ((ExpandedMapData)data).setCustomDataDirty(type, dirtySetter);
    }

    public record Type<T extends CustomMapData<?>>(class_2960 id, Supplier<T> factory) {
        @NotNull
        public T get(class_22 mapData) {
            return (T)((ExpandedMapData)mapData).getCustomData().get(this.id);
        }
    }

    public static interface DirtyCounter {
        public boolean isDirty();

        public void clearDirty();
    }

    public static class SimpleDirtyCounter
    implements DirtyCounter {
        private boolean dirty = true;

        public void markDirty() {
            this.dirty = true;
        }

        @Override
        public boolean isDirty() {
            return this.dirty;
        }

        @Override
        public void clearDirty() {
            this.dirty = false;
        }
    }
}

