/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidRegistryImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidClient;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftFluidRegistry {
    public static final class_2960 EMPTY_ID = Moonlight.res("empty");

    public static SoftFluid getEmpty() {
        return SoftFluidRegistry.get(EMPTY_ID);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidRegistryImpl.init();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5321<class_2378<SoftFluid>> getRegistryKey() {
        return SoftFluidRegistryImpl.getRegistryKey();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<class_3611, SoftFluid> getFluidsMap() {
        return SoftFluidRegistryImpl.getFluidsMap();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<class_1792, SoftFluid> getItemsMap() {
        return SoftFluidRegistryImpl.getItemsMap();
    }

    public static class_2378<SoftFluid> getDataPackRegistry() {
        return SoftFluidRegistry.getDataPackRegistry(Utils.hackyGetRegistryAccess());
    }

    public static class_2378<SoftFluid> getDataPackRegistry(class_5455 registryAccess) {
        return registryAccess.method_30530(SoftFluidRegistry.getRegistryKey());
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.getDataPackRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.getDataPackRegistry().method_29722();
    }

    public static SoftFluid get(String id) {
        return SoftFluidRegistry.get(new class_2960(id));
    }

    @Nullable
    public static class_2960 getID(SoftFluid s) {
        return SoftFluidRegistry.getDataPackRegistry().method_10221((Object)s);
    }

    public static SoftFluid get(class_2960 id) {
        SoftFluid r;
        String namespace = id.method_12836();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.method_12832());
        }
        if ((r = (SoftFluid)SoftFluidRegistry.getDataPackRegistry().method_10223(id)) == null) {
            return (SoftFluid)SoftFluidRegistry.getDataPackRegistry().method_10223(EMPTY_ID);
        }
        return r;
    }

    public static Optional<SoftFluid> getOptional(class_2960 id) {
        String namespace = id.method_12836();
        if (namespace.equals("selene") || namespace.equals("minecraft")) {
            id = Moonlight.res(id.method_12832());
        }
        return SoftFluidRegistry.getDataPackRegistry().method_17966(id);
    }

    public static SoftFluid fromVanillaFluid(class_3611 fluid) {
        return SoftFluidRegistry.getFluidsMap().getOrDefault(fluid, SoftFluidRegistry.getEmpty());
    }

    @Deprecated(forRemoval=true)
    public static SoftFluid fromForgeFluid(class_3611 fluid) {
        return SoftFluidRegistry.fromVanillaFluid(fluid);
    }

    @NotNull
    public static SoftFluid fromItem(class_1792 filledContainerItem) {
        return SoftFluidRegistry.getItemsMap().getOrDefault(filledContainerItem, SoftFluidRegistry.getEmpty());
    }

    private static void populateSlaveMaps() {
        Map<class_1792, SoftFluid> itemMap = SoftFluidRegistry.getItemsMap();
        itemMap.clear();
        Map<class_3611, SoftFluid> fluidsMap = SoftFluidRegistry.getFluidsMap();
        fluidsMap.clear();
        for (SoftFluid s : SoftFluidRegistry.getValues()) {
            if (!PlatformHelper.isModLoaded(s.getFromMod())) continue;
            s.getEquivalentFluids().forEach(f -> fluidsMap.put((class_3611)f, s));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || s != VanillaSoftFluids.WATER.get()) {
                    itemMap.put((class_1792)i, s);
                }
            });
        }
    }

    @ApiStatus.Internal
    public static void postInitClient() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidClient.refresh();
    }

    @ApiStatus.Internal
    public static void onDataSyncToPlayer(class_3222 player, boolean o) {
        ModMessages.CHANNEL.sendToClientPlayer(player, new ClientBoundFinalizeFluidsMessage());
    }

    @ApiStatus.Internal
    public static void onDataLoad() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidRegistry.registerExistingVanillaFluids();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerExistingVanillaFluids() {
        SoftFluidRegistryImpl.registerExistingVanillaFluids();
    }
}

