/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.fabric;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.fabric.FabricHooks;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;

public class FabricRecipeConditionManager {
    private static final Map<class_2960, Function<JsonObject, Boolean>> CONDITIONS = new HashMap<class_2960, Function<JsonObject, Boolean>>();

    public static void register(class_2960 id, Function<JsonObject, Boolean> function) {
        CONDITIONS.put(id, function);
    }

    public static void registerSimple(class_2960 id, Function<String, Boolean> predicate) {
        FabricRecipeConditionManager.register(id, j -> (Boolean)predicate.apply(j.get(id.method_12832()).getAsString()));
    }

    public static boolean isRecipeDisabled(@Nullable JsonElement conditions, class_2960 recipeId) {
        try {
            if (!FabricRecipeConditionManager.areConditionsMet(conditions)) {
                return true;
            }
        }
        catch (Exception e) {
            if (PlatformHelper.isDev()) {
                Moonlight.LOGGER.error("Failed to parse conditions for recipe {}", (Object)recipeId, (Object)e);
            }
            return false;
        }
        return false;
    }

    public static boolean areConditionsMet(@Nullable JsonElement conditions) {
        if (conditions instanceof JsonArray) {
            JsonArray array = (JsonArray)conditions;
            for (JsonElement v : array) {
                JsonObject jo;
                if (!(v instanceof JsonObject) || FabricRecipeConditionManager.isConditionSatisfied(jo = (JsonObject)v)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isConditionSatisfied(JsonObject jo) {
        String type = jo.get("type").getAsString();
        class_2960 res = new class_2960(type);
        Function<JsonObject, Boolean> c = CONDITIONS.get(res);
        if (c != null) {
            return c.apply(jo);
        }
        return true;
    }

    private static boolean forgeNot(JsonObject jsonObject) {
        JsonObject jo = jsonObject.getAsJsonObject("value");
        return !FabricRecipeConditionManager.isConditionSatisfied(jo);
    }

    private static boolean forgeAnd(JsonObject jsonObject) {
        JsonArray jo = jsonObject.getAsJsonArray("values");
        return FabricRecipeConditionManager.areConditionsMet((JsonElement)jo);
    }

    private static boolean forgeModLoaded(JsonObject jsonObject) {
        return PlatformHelper.isModLoaded(jsonObject.get("modid").getAsString());
    }

    private static Boolean forgeTagEmpty(JsonObject object) {
        class_6862 key = class_6862.method_40092((class_5321)class_2378.field_25108, (class_2960)new class_2960(class_3518.method_15265((JsonObject)object, (String)"tag")));
        FabricHooks.TagContext tagContext = FabricHooks.getTagContext();
        if (tagContext != null) {
            return ((Collection)tagContext.getAllTags(key.comp_326()).getOrDefault(key.comp_327(), Set.of())).isEmpty();
        }
        return true;
    }

    static {
        FabricRecipeConditionManager.register(new class_2960("forge:mod_loaded"), FabricRecipeConditionManager::forgeModLoaded);
        FabricRecipeConditionManager.register(new class_2960("forge:and"), FabricRecipeConditionManager::forgeAnd);
        FabricRecipeConditionManager.register(new class_2960("forge:not"), FabricRecipeConditionManager::forgeNot);
        FabricRecipeConditionManager.register(new class_2960("forge:tag_empty"), FabricRecipeConditionManager::forgeTagEmpty);
    }
}

