/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.set.fabric;

import java.util.ArrayDeque;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import net.mehvahdjukaar.moonlight.api.set.BlockSetAPI;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.core.set.BlockSetInternal;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;

public class BlockSetInternalImpl {
    public static boolean hasFilledBlockSets = false;
    public static final Map<Class<? extends BlockType>, Queue<BlockSetAPI.BlockTypeRegistryCallback<class_2248, ?>>> BLOCK_QUEUE = new LinkedHashMap();
    public static final Map<Class<? extends BlockType>, Queue<BlockSetAPI.BlockTypeRegistryCallback<class_1792, ?>>> ITEM_QUEUE = new LinkedHashMap();

    public static boolean hasFilledBlockSets() {
        return hasFilledBlockSets;
    }

    public static <T extends BlockType> void addDynamicBlockRegistration(BlockSetAPI.BlockTypeRegistryCallback<class_2248, T> registrationFunction, Class<T> blockType) {
        BLOCK_QUEUE.computeIfAbsent(blockType, b -> new ArrayDeque()).add(registrationFunction);
    }

    public static <T extends BlockType> void addDynamicItemRegistration(BlockSetAPI.BlockTypeRegistryCallback<class_1792, T> registrationFunction, Class<T> blockType) {
        ITEM_QUEUE.computeIfAbsent(blockType, b -> new ArrayDeque()).add(registrationFunction);
    }

    public static void registerEntries() {
        BlockSetInternal.initializeBlockSets();
        for (Map.Entry<Class<BlockType>, Queue<BlockSetAPI.BlockTypeRegistryCallback<class_2248, ?>>> entry : BLOCK_QUEUE.entrySet()) {
            BlockSetInternalImpl.registerQueue(entry.getKey(), entry.getValue(), class_2378.field_11146);
        }
        for (Map.Entry<Class<BlockType>, Queue<BlockSetAPI.BlockTypeRegistryCallback<class_2248, ?>>> entry : ITEM_QUEUE.entrySet()) {
            BlockSetInternalImpl.registerQueue(entry.getKey(), entry.getValue(), class_2378.field_11142);
        }
    }

    private static <R, T extends BlockType> void registerQueue(Class<T> type, Queue<BlockSetAPI.BlockTypeRegistryCallback<R, ?>> callback, class_2378<R> registry) {
        callback.forEach(a -> a.accept((n, i) -> class_2378.method_10230((class_2378)registry, (class_2960)n, (Object)i), BlockSetAPI.getBlockSet(type).getValues()));
    }
}

