/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.fabric.FabricRecipeConditionManager;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1863.class})
public abstract class RecipeManagerMixin {
    @Unique
    private static final Set<class_2960> DISABLED_RECIPES = new HashSet<class_2960>();

    @Inject(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at={@At(value="TAIL")})
    public void clearDisabledRecipes(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        DISABLED_RECIPES.clear();
    }

    @Inject(method={"fromJson"}, at={@At(value="HEAD")})
    private static void handleForgeConditions(class_2960 recipeId, JsonObject json, CallbackInfoReturnable<class_1860<?>> cir) {
        if (FabricRecipeConditionManager.isRecipeDisabled(json.get("conditions"), recipeId)) {
            DISABLED_RECIPES.add(recipeId);
            throw new IllegalArgumentException("Skipping " + recipeId + " as its conditions were not met");
        }
    }

    @Redirect(method={"apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V"}, at=@At(value="INVOKE", target="Lorg/slf4j/Logger;error(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V"), require=0)
    public void disableExceptions(Logger instance, String s, Object o1, Object o2) {
        class_2960 res;
        if (!(o1 instanceof class_2960) || !DISABLED_RECIPES.contains(res = (class_2960)o1)) {
            instance.error(s, o1, o2);
        }
    }
}

