/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.client.GenericSimpleResourceReloadListener;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5253;
import net.minecraft.class_5321;

public class SoftFluidClient
extends GenericSimpleResourceReloadListener {
    private static final List<class_2960> TEXTURES_TO_STITCH = new ArrayList<class_2960>();
    private static final HashMap<class_2960, Integer> PARTICLE_COLORS = new HashMap();

    public SoftFluidClient() {
        super("textures/soft_fluids", ".png");
    }

    @Override
    public void apply(List<class_2960> locations, class_3300 manager, class_3695 filler) {
        TEXTURES_TO_STITCH.clear();
        TEXTURES_TO_STITCH.addAll(locations);
    }

    public static int get(SoftFluid s) {
        return PARTICLE_COLORS.getOrDefault(SoftFluidRegistry.getID(s), -1);
    }

    public static List<class_2960> getTexturesToStitch() {
        ArrayList<class_2960> list = new ArrayList<class_2960>();
        TEXTURES_TO_STITCH.forEach(e -> list.add(new class_2960(e.method_12836(), "soft_fluids/" + e.method_12832())));
        return list;
    }

    public static void refresh() {
        if (class_310.method_1551().field_1687 == null) {
            return;
        }
        Set<Map.Entry<class_5321<SoftFluid>, SoftFluid>> v = SoftFluidRegistry.getEntries();
        PARTICLE_COLORS.clear();
        for (Map.Entry<class_5321<SoftFluid>, SoftFluid> entry : v) {
            class_2960 location;
            SoftFluid s = entry.getValue();
            class_2960 key = entry.getKey().method_29177();
            if (PARTICLE_COLORS.containsKey(key) || s.isColored() || (location = s.getStillTexture()) == null) continue;
            class_1059 textureMap = class_310.method_1551().method_1554().method_24153(class_1059.field_5275);
            class_1058 sprite = textureMap.method_4608(location);
            int averageColor = -1;
            try {
                averageColor = SoftFluidClient.getColorFrom(sprite, s.getTintColor());
            }
            catch (Exception e) {
                Moonlight.LOGGER.warn("Failed to load particle color for " + sprite + " using current resource pack. might be a broken png.mcmeta");
            }
            PARTICLE_COLORS.put(key, averageColor);
        }
    }

    private static int getColorFrom(class_1058 sprite, int tint) {
        if (sprite == null || sprite.method_4592() == 0) {
            return -1;
        }
        int tintR = tint >> 16 & 0xFF;
        int tintG = tint >> 8 & 0xFF;
        int tintB = tint & 0xFF;
        int total = 0;
        int totalR = 0;
        int totalB = 0;
        int totalG = 0;
        for (int tryFrame = 0; tryFrame < sprite.method_4592(); ++tryFrame) {
            try {
                for (int x = 0; x < sprite.method_4578(); ++x) {
                    for (int y = 0; y < sprite.method_4595(); ++y) {
                        int pixel = ClientPlatformHelper.getPixelRGBA(sprite, tryFrame, x, y);
                        int pixelB = pixel >> 16 & 0xFF;
                        int pixelG = pixel >> 8 & 0xFF;
                        int pixelR = pixel & 0xFF;
                        ++total;
                        totalR += pixelR;
                        totalG += pixelG;
                        totalB += pixelB;
                    }
                }
                break;
            }
            catch (Exception e) {
                total = 0;
                totalR = 0;
                totalB = 0;
                totalG = 0;
                continue;
            }
        }
        if (total <= 0) {
            return -1;
        }
        return class_5253.class_5254.method_27764((int)255, (int)(totalR / total * tintR / 255), (int)(totalG / total * tintG / 255), (int)(totalB / total * tintB / 255));
    }
}

