/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class BlockTypeRegistry<T extends BlockType> {
    protected boolean frozen = false;
    private final String name;
    private final List<BlockType.SetFinder<T>> finders = new ArrayList<BlockType.SetFinder<T>>();
    private final List<class_2960> notInclude = new ArrayList<class_2960>();
    private final List<T> builder = new ArrayList<T>();
    private final Class<T> typeClass;
    private Map<class_2960, T> types = new LinkedHashMap<class_2960, T>();

    public BlockTypeRegistry(Class<T> typeClass, String name) {
        this.typeClass = typeClass;
        this.name = name;
    }

    public Class<T> getType() {
        return this.typeClass;
    }

    public T getFromNBT(String name) {
        return (T)((BlockType)this.types.getOrDefault(new class_2960(name), this.getDefaultType()));
    }

    @Nullable
    public T get(class_2960 res) {
        return (T)((BlockType)this.types.get(res));
    }

    public abstract T getDefaultType();

    public Collection<T> getValues() {
        return Collections.unmodifiableCollection(this.types.values());
    }

    public String typeName() {
        return this.name;
    }

    public abstract Optional<T> detectTypeFromBlock(class_2248 var1);

    public void registerBlockType(T newType) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a wood types after registry events");
        }
        this.builder.add(newType);
    }

    public Collection<BlockType.SetFinder<T>> getFinders() {
        return this.finders;
    }

    public void addFinder(BlockType.SetFinder<T> finder) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried to register a block type finder after registry events");
        }
        this.finders.add(finder);
    }

    public void addRemover(class_2960 id) {
        if (this.frozen) {
            throw new UnsupportedOperationException("Tried remove a block type after registry events");
        }
        this.notInclude.add(id);
    }

    private void finalizeAndFreeze() {
        if (this.frozen) {
            throw new UnsupportedOperationException("Block types are already finalized");
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<String> modOrder = new ArrayList<String>();
        modOrder.add("minecraft");
        this.builder.forEach(e -> {
            String modId = e.getNamespace();
            if (!modOrder.contains(modId)) {
                modOrder.add(modId);
            }
        });
        for (String modId : modOrder) {
            this.builder.forEach(e -> {
                if (Objects.equals(e.getNamespace(), modId) && !linkedHashMap.containsKey(e.getId())) {
                    linkedHashMap.put(e.getId(), e);
                }
            });
        }
        this.types = ImmutableMap.copyOf(linkedHashMap);
        this.builder.clear();
        this.frozen = true;
    }

    public void buildAll() {
        if (!this.frozen) {
            this.registerBlockType(this.getDefaultType());
            Collection<BlockType.SetFinder<T>> finders = this.getFinders();
            finders.stream().map(BlockType.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
            for (class_2248 b : class_2378.field_11146) {
                this.detectTypeFromBlock(b).ifPresent(t -> {
                    if (!this.notInclude.contains(t.getId())) {
                        this.registerBlockType(t);
                    }
                });
            }
            this.finalizeAndFreeze();
        }
    }

    public void addTypeTranslations(AfterLanguageLoadEvent language) {
    }
}

