/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.resources.assets.LangBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public abstract class BlockType {
    private final Map<String, class_1935> children = new HashMap<String, class_1935>();
    boolean needsInit = true;
    public final class_2960 id;

    public BlockType(class_2960 resourceLocation) {
        this.id = resourceLocation;
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getTypeName() {
        return this.id.method_12832();
    }

    public String getNamespace() {
        return this.id.method_12836();
    }

    public String getAppendableId() {
        return this.getNamespace() + "/" + this.getTypeName();
    }

    public String toString() {
        return this.id.toString();
    }

    public abstract String getTranslationKey();

    public String getVariantId(String baseName) {
        String namespace;
        String string = namespace = this.isVanilla() ? "" : this.getNamespace() + "/";
        if (baseName.contains("%s")) {
            return namespace + String.format(baseName, this.getTypeName());
        }
        return namespace + baseName + "_" + this.getTypeName();
    }

    public String getVariantId(String baseName, boolean prefix) {
        return this.getVariantId(prefix ? baseName + "_%s" : "%s_" + baseName);
    }

    public String getVariantId(String postfix, String prefix) {
        return this.getVariantId(prefix + "_%s_" + postfix);
    }

    public String getReadableName() {
        return LangBuilder.getReadableName(this.getTypeName());
    }

    public boolean isVanilla() {
        return this.getNamespace().equals("minecraft");
    }

    @Nullable
    protected <V> V findRelatedEntry(String appendedName, class_2378<V> reg) {
        return this.findRelatedEntry(appendedName, "", reg);
    }

    @Nullable
    protected <V> V findRelatedEntry(String append, String postPend, class_2378<V> reg) {
        Object post = postPend.isEmpty() ? "" : "_" + postPend;
        class_2960 id = this.getId();
        class_2960[] targets = new class_2960[]{new class_2960(id.method_12836(), id.method_12832() + "_" + append + (String)post), new class_2960(id.method_12836(), append + "_" + id.method_12832() + (String)post), new class_2960(id.method_12836(), id.method_12832() + "_planks_" + append + (String)post)};
        Object found = null;
        for (class_2960 r : targets) {
            if (!reg.method_10250(r)) continue;
            found = reg.method_10223(r);
            break;
        }
        return (V)found;
    }

    public Set<Map.Entry<String, class_1935>> getChildren() {
        if (this.needsInit) {
            this.initAfterSetup();
        }
        return this.children.entrySet();
    }

    @Nullable
    public class_1792 getItemOfThis(String key) {
        class_1935 v = this.getChild(key);
        return v == null ? null : v.method_8389();
    }

    @Nullable
    public class_2248 getBlockOfThis(String key) {
        class_2248 b;
        class_1935 v = this.getChild(key);
        return v instanceof class_2248 ? (b = (class_2248)v) : null;
    }

    @Nullable
    public class_1935 getChild(String key) {
        if (this.needsInit) {
            this.initAfterSetup();
        }
        return this.children.get(key);
    }

    public void addChild(String genericName, @Nullable class_1935 itemLike) {
        if (itemLike != null) {
            this.children.put(genericName, itemLike);
        }
    }

    protected abstract void initializeVanillaChildren();

    protected void initAfterSetup() {
        this.needsInit = false;
        this.initializeVanillaChildren();
    }

    public abstract class_1935 mainChild();

    @Nullable
    public static class_1935 changeItemBlockType(class_1935 current, BlockType originalMat, BlockType destinationMat) {
        if (destinationMat == originalMat) {
            return current;
        }
        for (Map.Entry<String, class_1935> c : originalMat.getChildren()) {
            class_1935 child = c.getValue();
            class_1935 replacement = null;
            if (current instanceof class_2248 && child instanceof class_2248) {
                if (current == child) {
                    replacement = destinationMat.getChild(c.getKey());
                }
            } else if (current.method_8389() == c.getValue().method_8389()) {
                replacement = destinationMat.getChild(c.getKey());
            }
            if (replacement == null) continue;
            return replacement;
        }
        return null;
    }

    public static abstract class SetFinder<T extends BlockType> {
        public abstract Optional<T> get();
    }
}

