/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.textures;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.resources.textures.Palette;
import net.mehvahdjukaar.moonlight.api.resources.textures.PaletteColor;
import net.mehvahdjukaar.moonlight.api.resources.textures.TextureImage;
import net.mehvahdjukaar.moonlight.api.util.math.colors.HSVColor;
import net.mehvahdjukaar.moonlight.api.util.math.colors.RGBColor;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.DataSet;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.IDataEntry;
import net.mehvahdjukaar.moonlight.api.util.math.kmeans.KMeans;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public final class SpriteUtils {
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_TOP_LOG_TEXTURE = s -> (s = new class_2960(s).method_12832()).contains("_top") || s.contains("_end") || s.contains("_up");
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_SIDE_LOG_TEXTURE = s -> !LOOKS_LIKE_TOP_LOG_TEXTURE.test((String)s);
    @NotNull
    public static final Predicate<String> LOOKS_LIKE_LEAF_TEXTURE = s -> !(s = new class_2960(s).method_12832()).contains("_bushy") && !s.contains("_snow");

    public static class_1011 readImage(class_3300 manager, class_2960 resourceLocation) throws IOException, NoSuchElementException {
        class_1011 class_10112;
        block8: {
            InputStream res = ((class_3298)manager.method_14486(resourceLocation).get()).method_14482();
            try {
                class_10112 = class_1011.method_4309((InputStream)res);
                if (res == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
            res.close();
        }
        return class_10112;
    }

    public static void forEachPixel(class_1011 image, BiConsumer<Integer, Integer> function) {
        for (int x = 0; x < image.method_4307(); ++x) {
            for (int y = 0; y < image.method_4323(); ++y) {
                function.accept(x, y);
            }
        }
    }

    public static void grayscaleImage(class_1011 image) {
        SpriteUtils.forEachPixel(image, (x, y) -> image.method_4305(x.intValue(), y.intValue(), new RGBColor(image.method_4315(x.intValue(), y.intValue())).asHCL().withChroma(0.0f).asRGB().toInt()));
    }

    public static List<Palette> extrapolateSignBlockPalette(TextureImage planksTexture) {
        ArrayList<Palette> newPalettes = new ArrayList<Palette>();
        List<Palette> oakPalettes = Palette.fromAnimatedImage(planksTexture, null, 0.0033333334f);
        for (Palette palette : oakPalettes) {
            int size = palette.size();
            if (size == 7) {
                PaletteColor color = palette.get(size - 3);
                HSVColor hsv = color.rgb().asHSV();
                float satIncrease = 1.0638298f;
                float brightnessIncrease = 1.0638298f;
                HSVColor newCol = new HSVColor(hsv.hue(), class_3532.method_15363((float)(hsv.saturation() * satIncrease), (float)0.0f, (float)1.0f), class_3532.method_15363((float)(hsv.value() * brightnessIncrease), (float)0.0f, (float)1.0f), hsv.alpha());
                PaletteColor newP = new PaletteColor(newCol);
                newP.occurrence = color.occurrence;
                palette.set(size - 1, newP);
                palette.remove(size - 2);
            }
            newPalettes.add(palette);
        }
        return newPalettes;
    }

    public static Palette extrapolateWoodItemPalette(TextureImage planksTexture) {
        Palette palette = Palette.fromAnimatedImage(planksTexture, null).get(0);
        PaletteColor color = palette.get(0);
        HSVColor hsv = color.rgb().asHSV();
        float satMult = 1.11f;
        float brightnessMult = 0.94f;
        HSVColor newCol = new HSVColor(hsv.hue(), class_3532.method_15363((float)(hsv.saturation() * satMult), (float)0.0f, (float)1.0f), class_3532.method_15363((float)(hsv.value() * brightnessMult), (float)0.0f, (float)1.0f), hsv.alpha());
        PaletteColor newP = new PaletteColor(newCol);
        newP.occurrence = color.occurrence;
        palette.set(0, newP);
        return palette;
    }

    @Deprecated
    public static float getLuminance(int r, int g, int b) {
        return 0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b;
    }

    public static void reduceColors(class_1011 image, Function<Integer, Integer> sizeFn) {
        Palette p = Palette.fromImage(TextureImage.of(image, null), null, 0.0f);
        if (p.size() == 0) {
            return;
        }
        DataSet<DataSet.ColorPoint> data = DataSet.fromPalette(p);
        int size = sizeFn.apply(p.size());
        if (size >= p.size()) {
            return;
        }
        KMeans.kMeans(data, size);
        HashMap<Integer, Integer> colorToColorMap = new HashMap<Integer, Integer>();
        for (IDataEntry<DataSet.ColorPoint> c : data.getColorPoints()) {
            IDataEntry<DataSet.ColorPoint> centroid = data.getLastCentroids().get(c.getClusterNo());
            colorToColorMap.put(c.cast().getColor().value(), centroid.cast().getColor().value());
        }
        SpriteUtils.forEachPixel(image, (x, y) -> {
            int i = image.method_4315(x.intValue(), y.intValue());
            if (colorToColorMap.containsKey(i)) {
                image.method_4305(x.intValue(), y.intValue(), ((Integer)colorToColorMap.get(i)).intValue());
            }
        });
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static boolean looksLikeTopLogTexture(String s) {
        return (s = new class_2960(s).method_12832()).contains("_top") || s.contains("_end") || s.contains("_up");
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static boolean looksLikeSideLogTexture(String s) {
        return !SpriteUtils.looksLikeTopLogTexture(s);
    }
}

