/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.pack;

import com.google.common.base.Stopwatch;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcePack;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicTexturePack;
import net.mehvahdjukaar.moonlight.core.misc.VanillaResourceManager;
import net.minecraft.class_2960;
import net.minecraft.class_3283;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class DynResourceProvider<T extends DynamicResourcePack>
implements class_3302 {
    public final T dynamicPack;
    private boolean hasBeenInitialized;

    protected DynResourceProvider(T pack) {
        this.dynamicPack = pack;
    }

    public void register() {
        ((DynamicResourcePack)this.dynamicPack).registerPack();
    }

    public abstract Logger getLogger();

    public T getPack() {
        return this.dynamicPack;
    }

    public abstract boolean dependsOnLoadedPacks();

    public abstract void regenerateDynamicAssets(class_3300 var1);

    public void generateStaticAssetsOnStartup(class_3300 manager) {
    }

    public final CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 manager, class_3695 workerProfiler, class_3695 mainProfiler, Executor workerExecutor, Executor mainExecutor) {
        this.reloadResources(manager);
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> null, workerExecutor).thenCompose(arg_0 -> ((class_3302.class_4045)stage).method_18352(arg_0))).thenAcceptAsync(noResult -> {}, mainExecutor);
    }

    protected void reloadResources(class_3300 manager) {
        Stopwatch watch = Stopwatch.createStarted();
        boolean resourcePackSupport = this.dependsOnLoadedPacks();
        if (!this.hasBeenInitialized) {
            this.hasBeenInitialized = true;
            this.generateStaticAssetsOnStartup(manager);
            T t = this.dynamicPack;
            if (t instanceof DynamicTexturePack) {
                DynamicTexturePack tp = (DynamicTexturePack)t;
                tp.addPackLogo();
            }
            if (!resourcePackSupport) {
                class_3283 pack = this.getRepository();
                if (pack != null) {
                    VanillaResourceManager vanillaManager = new VanillaResourceManager(pack);
                    this.regenerateDynamicAssets(vanillaManager);
                    vanillaManager.close();
                } else {
                    this.regenerateDynamicAssets(manager);
                }
            }
        }
        if (resourcePackSupport) {
            this.regenerateDynamicAssets(manager);
        }
        this.getLogger().info("Generated runtime {} for pack {} in: {} ms", (Object)((DynamicResourcePack)this.dynamicPack).getPackType(), (Object)((DynamicResourcePack)this.dynamicPack).method_14409(), (Object)watch.elapsed().toMillis());
    }

    @Nullable
    protected abstract class_3283 getRepository();

    public boolean alreadyHasAssetAtLocation(class_3300 manager, class_2960 res, ResType type) {
        class_2960 fullRes = type.getPath(res);
        Optional resource = manager.method_14486(fullRes);
        return resource.filter(value -> !value.method_14480().equals(((DynamicResourcePack)this.dynamicPack).method_14409())).isPresent();
    }
}

