/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.fabric;

import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.registry.FlammableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.core.mixins.fabric.PackRepositoryAccessor;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundSpawnCustomEntityMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.mehvahdjukaar.moonlight.core.network.fabric.ClientBoundOpenScreenMessage;
import net.mehvahdjukaar.moonlight.fabric.MoonlightFabric;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1813;
import net.minecraft.class_1826;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3288;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3414;
import net.minecraft.class_3695;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PlatformHelperImpl {
    private static final HashMap<class_3264, List<Supplier<class_3288>>> EXTRA_PACKS = new HashMap();

    public static PlatformHelper.Platform getPlatform() {
        return PlatformHelper.Platform.FABRIC;
    }

    public static boolean isData() {
        return false;
    }

    public static boolean isModLoaded(String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }

    @Nullable
    public static <T> Field findField(Class<? super T> clazz, String fieldName) {
        return null;
    }

    @Nullable
    public static Method findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return null;
    }

    public static boolean isMobGriefingOn(class_1937 level, class_1297 entity) {
        return level.method_8450().method_8355(class_1928.field_19388);
    }

    public static boolean isAreaLoaded(class_4538 level, class_2338 pos, int maxRange) {
        return level.method_22343(pos.method_10069(-maxRange, -maxRange, -maxRange), pos.method_10069(maxRange, maxRange, maxRange));
    }

    public static int getFlammability(class_2680 state, class_1922 level, class_2338 pos, class_2350 face) {
        return ((FlammableBlockRegistry.Entry)FlammableBlockRegistry.getDefaultInstance().get(state.method_26204())).getBurnChance();
    }

    public static PlatformHelper.Env getEnv() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? PlatformHelper.Env.CLIENT : PlatformHelper.Env.SERVER;
    }

    @Nullable
    public static class_4174 getFoodProperties(class_1792 food, class_1799 stack, class_1657 player) {
        return food.method_19264();
    }

    public static boolean isCurativeItem(class_1799 stack, class_1293 effect) {
        return stack.method_7909() == class_1802.field_8103 || stack.method_7909() == class_1802.field_20417;
    }

    public static boolean isDev() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static int getBurnTime(class_1799 stack) {
        Integer v = (Integer)FuelRegistry.INSTANCE.get((class_1935)stack.method_7909());
        if (v == null) {
            return 0;
        }
        return v;
    }

    @Nullable
    public static MinecraftServer getCurrentServer() {
        return MoonlightFabric.currentServer;
    }

    public static class_2596<?> getEntitySpawnPacket(class_1297 entity) {
        ClientBoundSpawnCustomEntityMessage packet = new ClientBoundSpawnCustomEntityMessage(entity);
        class_2540 buf = new class_2540(Unpooled.buffer());
        packet.writeToBuffer(buf);
        return ServerPlayNetworking.createS2CPacket((class_2960)ModMessages.SPAWN_PACKET_ID, (class_2540)buf);
    }

    public static Path getGamePath() {
        return FabricLoader.getInstance().getGameDir();
    }

    public static class_1761 createModTab(class_2960 name, Supplier<class_1799> icon, boolean hasSearchBar, @Nullable BiConsumer<List<class_1799>, class_1761> fillItemList) {
        FabricItemGroupBuilder t = FabricItemGroupBuilder.create((class_2960)name);
        t.appendItems(fillItemList).icon(icon);
        return t.build();
    }

    public static void registerResourcePack(class_3264 packType, Supplier<class_3288> packSupplier) {
        class_3283 class_32832;
        EXTRA_PACKS.computeIfAbsent(packType, p -> new ArrayList()).add(packSupplier);
        if (packType == class_3264.field_14188 && PlatformHelper.getEnv().isClient() && (class_32832 = class_310.method_1551().method_1520()) instanceof PackRepositoryAccessor) {
            PackRepositoryAccessor rep = (PackRepositoryAccessor)class_32832;
            HashSet<class_3285> newSources = new HashSet<class_3285>(rep.getSources());
            PlatformHelperImpl.getAdditionalPacks(packType).forEach(l -> newSources.add((arg_0, arg_1) -> PlatformHelperImpl.lambda$registerResourcePack$1((Supplier)l, arg_0, arg_1)));
            rep.setSources(newSources);
        }
    }

    public static Collection<Supplier<class_3288>> getAdditionalPacks(class_3264 packType) {
        ArrayList<Supplier<class_3288>> list = new ArrayList<Supplier<class_3288>>();
        List<Supplier<class_3288>> suppliers = EXTRA_PACKS.get(packType);
        if (suppliers != null) {
            list.addAll(suppliers);
        }
        return list;
    }

    public static class_1826 newSpawnEgg(Supplier<? extends class_1299<? extends class_1308>> entityType, int color, int outerColor, class_1792.class_1793 properties) {
        return new class_1826(entityType.get(), color, outerColor, properties);
    }

    public static Path getModFilePath(String modId) {
        return (Path)((ModContainer)FabricLoader.getInstance().getModContainer(modId).get()).getRootPaths().get(0);
    }

    public static class_2362 newFlowerPot(@Nullable Supplier<class_2362> emptyPot, Supplier<? extends class_2248> supplier, class_4970.class_2251 properties) {
        return new class_2362(supplier.get(), properties);
    }

    public static class_1813 newMusicDisc(int power, Supplier<class_3414> music, class_1792.class_1793 properties) {
        class ModRecord
        extends class_1813 {
            protected ModRecord(int i, class_3414 soundEvent, class_1792.class_1793 properties) {
                super(i, soundEvent, properties);
            }
        }
        return new ModRecord(power, music.get(), properties);
    }

    public static <T extends class_2586> class_2591<T> newBlockEntityType(PlatformHelper.BlockEntitySupplier<T> blockEntitySupplier, class_2248 ... validBlocks) {
        return FabricBlockEntityTypeBuilder.create(blockEntitySupplier::create, (class_2248[])validBlocks).build();
    }

    public static <E extends class_1297> class_1299<E> newEntityType(String name, class_1299.class_4049<E> factory, class_1311 category, float width, float height, int clientTrackingRange, boolean velocityUpdates, int updateInterval) {
        return FabricEntityTypeBuilder.create((class_1311)category, factory).dimensions(class_4048.method_18384((float)width, (float)height)).trackedUpdateRate(updateInterval).trackRangeChunks(clientTrackingRange).forceTrackedVelocityUpdates(velocityUpdates).build();
    }

    public static void addServerReloadListener(final class_3302 listener, final class_2960 name) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(new IdentifiableResourceReloadListener(){

            public class_2960 getFabricId() {
                return name;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
                return listener.method_25931(preparationBarrier, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }
        });
    }

    public static void openCustomMenu(class_3222 player, class_3908 menuProvider, Consumer<class_2540> extraDataProvider) {
        ClientBoundOpenScreenMessage.openMenu(player, menuProvider, extraDataProvider);
    }

    private static /* synthetic */ void lambda$registerResourcePack$1(Supplier l, Consumer infoConsumer, class_3288.class_5351 b) {
        infoConsumer.accept((class_3288)l.get());
    }
}

