/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values;

import com.google.gson.JsonObject;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class EnumConfigValue<T extends Enum<T>>
extends ConfigValue<T> {
    private final T[] acceptedValues;

    public EnumConfigValue(String name, T defaultValue) {
        super(name, defaultValue);
        this.acceptedValues = (Enum[])((Enum)defaultValue).getDeclaringClass().getEnumConstants();
    }

    @Override
    public boolean isValid(T value) {
        return true;
    }

    public Class<T> getEnum() {
        return ((Enum)this.defaultValue).getDeclaringClass();
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                String s = element.get(this.name).getAsString();
                for (T v : this.acceptedValues) {
                    if (!((Enum)v).name().equals(s)) continue;
                    this.value = v;
                    return;
                }
                if (this.isValid((T)((Enum)this.value))) {
                    return;
                }
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Moonlight.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            Moonlight.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        object.addProperty(this.name, ((Enum)this.value).name());
    }
}

