/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.platform.configs.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigEntry;
import net.mehvahdjukaar.moonlight.core.Moonlight;

public class ConfigCategory
extends ConfigEntry {
    private final List<ConfigEntry> entries = new ArrayList<ConfigEntry>();

    public ConfigCategory(String name) {
        super(name);
    }

    public void addEntry(ConfigEntry entry) {
        this.entries.add(entry);
    }

    public List<ConfigEntry> getEntries() {
        return this.entries;
    }

    @Override
    public void loadFromJson(JsonObject object) {
        if (object.has(this.name)) {
            JsonElement o = object.get(this.name);
            if (o instanceof JsonObject) {
                JsonObject jo = (JsonObject)o;
                this.entries.forEach(l -> l.loadFromJson(jo));
            }
            return;
        }
        Moonlight.LOGGER.warn("Config file had missing category {}", (Object)this.name);
    }

    @Override
    public void saveToJson(JsonObject object) {
        JsonObject category = new JsonObject();
        this.entries.forEach(l -> l.saveToJson(category));
        object.add(this.name, (JsonElement)category);
    }
}

