/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_5321;

public abstract class MapBlockMarker<D extends CustomMapDecoration> {
    private final MapDecorationType<D, ?> type;
    public class_2338 pos;

    public MapBlockMarker(MapDecorationType<D, ?> type) {
        this.type = type;
    }

    public MapBlockMarker(MapDecorationType<D, ?> type, class_2338 pos) {
        this(type);
        this.pos = pos;
    }

    public void loadFromNBT(class_2487 compound) {
        this.pos = class_2512.method_10691((class_2487)compound.method_10562("Pos"));
    }

    public class_2487 saveToNBT(class_2487 compound) {
        compound.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)this.getPos()));
        return compound;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            MapBlockMarker marker = (MapBlockMarker)other;
            return Objects.equals(this.getPos(), marker.getPos());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos());
    }

    private String getPosSuffix() {
        return this.pos.method_10263() + "," + this.pos.method_10264() + "," + this.pos.method_10260();
    }

    public MapDecorationType<D, ?> getType() {
        return this.type;
    }

    public String getTypeId() {
        return Utils.getID(this.type).toString();
    }

    public String getMarkerId() {
        return this.getTypeId() + "-" + this.getPosSuffix();
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public void setPos(class_2338 pos) {
        this.pos = pos;
    }

    public int getRotation() {
        return 0;
    }

    @Nullable
    protected abstract D doCreateDecoration(byte var1, byte var2, byte var3);

    @Nullable
    public D createDecorationFromMarker(byte scale, int x, int z, class_5321<class_1937> dimension, boolean locked) {
        double worldX = this.getPos().method_10263();
        double worldZ = this.getPos().method_10260();
        double rotation = this.getRotation();
        int i = 1 << scale;
        float f = (float)(worldX - (double)x) / (float)i;
        float f1 = (float)(worldZ - (double)z) / (float)i;
        byte mapX = (byte)((double)(f * 2.0f) + 0.5);
        byte mapY = (byte)((double)(f1 * 2.0f) + 0.5);
        if (f >= -64.0f && f1 >= -64.0f && f <= 64.0f && f1 <= 64.0f) {
            byte rot = (byte)((rotation += rotation < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            return this.doCreateDecoration(mapX, mapY, rot);
        }
        return null;
    }

    public boolean shouldUpdate(MapBlockMarker<?> other) {
        return false;
    }

    public void updateDecoration(CustomMapDecoration old) {
    }
}

