/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.integration.cloth_config;

import java.util.List;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.gui.entries.EnumListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.ColorFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.DoubleFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.EnumSelectorBuilder;
import me.shedaniel.clothconfig2.impl.builders.IntFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringListBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigCategory;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.ConfigEntry;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.FabricConfigSpec;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.BoolConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ColorConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.DoubleConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.EnumConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.IntConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.ListStringConfigValue;
import net.mehvahdjukaar.moonlight.api.platform.configs.fabric.values.StringConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothConfigCompat {
    public static class_437 makeScreen(class_437 parent, FabricConfigSpec spec) {
        return ClothConfigCompat.makeScreen(parent, spec, null);
    }

    public static class_437 makeScreen(class_437 parent, FabricConfigSpec spec, @Nullable class_2960 background) {
        spec.loadFromFile();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle(spec.getName());
        if (background != null) {
            builder.setDefaultBackgroundTexture(background);
        }
        builder.setSavingRunnable(spec::saveConfig);
        for (ConfigEntry en : spec.getMainEntry().getEntries()) {
            if (!(en instanceof ConfigCategory)) continue;
            ConfigCategory c = (ConfigCategory)en;
            me.shedaniel.clothconfig2.api.ConfigCategory mainCat = builder.getOrCreateCategory((class_2561)class_2561.method_43471((String)c.getName()));
            for (ConfigEntry entry : c.getEntries()) {
                if (entry instanceof ConfigCategory) {
                    ConfigCategory subCat = (ConfigCategory)entry;
                    SubCategoryBuilder subBuilder = builder.entryBuilder().startSubCategory((class_2561)class_2561.method_43471((String)subCat.getName()));
                    ClothConfigCompat.addEntriesRecursive(builder, subBuilder, subCat);
                    mainCat.addEntry((AbstractConfigListEntry)subBuilder.build());
                    continue;
                }
                mainCat.addEntry(ClothConfigCompat.buildEntry(builder, entry));
            }
        }
        return builder.build();
    }

    private static void addEntriesRecursive(ConfigBuilder builder, SubCategoryBuilder subCategoryBuilder, ConfigCategory c) {
        for (ConfigEntry entry : c.getEntries()) {
            if (entry instanceof ConfigCategory) {
                ConfigCategory cc = (ConfigCategory)entry;
                SubCategoryBuilder scb = builder.entryBuilder().startSubCategory((class_2561)class_2561.method_43471((String)entry.getName()));
                ClothConfigCompat.addEntriesRecursive(builder, scb, cc);
                subCategoryBuilder.add((AbstractConfigListEntry)scb.build());
                continue;
            }
            subCategoryBuilder.add(ClothConfigCompat.buildEntry(builder, entry));
        }
    }

    private static AbstractConfigListEntry<?> buildEntry(ConfigBuilder builder, ConfigEntry entry) {
        if (entry instanceof ColorConfigValue) {
            ColorConfigValue col = (ColorConfigValue)entry;
            ColorFieldBuilder e = builder.entryBuilder().startAlphaColorField(col.getTranslation(), ((Integer)col.get()).intValue()).setDefaultValue(((Integer)col.getDefaultValue()).intValue()).setSaveConsumer(col::set);
            class_2561 description = col.getDescription();
            if (description != null) {
                e.setTooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof IntConfigValue) {
            IntConfigValue ic = (IntConfigValue)entry;
            IntFieldBuilder e = builder.entryBuilder().startIntField(ic.getTranslation(), ((Integer)ic.get()).intValue()).setMax(ic.getMax().intValue()).setMin(ic.getMin().intValue()).setDefaultValue(((Integer)ic.getDefaultValue()).intValue()).setSaveConsumer(ic::set);
            class_2561 description = ic.getDescription();
            if (description != null) {
                e.setTooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof DoubleConfigValue) {
            DoubleConfigValue dc = (DoubleConfigValue)entry;
            DoubleFieldBuilder e = builder.entryBuilder().startDoubleField(dc.getTranslation(), ((Double)dc.get()).doubleValue()).setMax(dc.getMax().doubleValue()).setMin(dc.getMin().doubleValue()).setDefaultValue(((Double)dc.getDefaultValue()).doubleValue()).setSaveConsumer(dc::set);
            class_2561 description = dc.getDescription();
            if (description != null) {
                e.setTooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof StringConfigValue) {
            StringConfigValue sc = (StringConfigValue)entry;
            StringFieldBuilder e = builder.entryBuilder().startStrField(sc.getTranslation(), (String)sc.get()).setDefaultValue((String)sc.getDefaultValue()).setSaveConsumer(sc::set);
            class_2561 description = sc.getDescription();
            if (description != null) {
                e.setTooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof BoolConfigValue) {
            BoolConfigValue bc = (BoolConfigValue)entry;
            BooleanToggleBuilder e = builder.entryBuilder().startBooleanToggle(bc.getTranslation(), ((Boolean)bc.get()).booleanValue()).setDefaultValue(((Boolean)bc.getDefaultValue()).booleanValue()).setSaveConsumer(bc::set);
            class_2561 description = bc.getDescription();
            if (description != null) {
                e.setTooltip(new class_2561[]{description});
            }
            return e.build();
        }
        if (entry instanceof EnumConfigValue) {
            EnumConfigValue ec = (EnumConfigValue)entry;
            return ClothConfigCompat.addEnum(builder, ec);
        }
        if (entry instanceof ListStringConfigValue) {
            ListStringConfigValue lc = (ListStringConfigValue)entry;
            StringListBuilder e = builder.entryBuilder().startStrList(lc.getTranslation(), (List)lc.get()).setDefaultValue((List)lc.getDefaultValue()).setSaveConsumer(lc::set);
            class_2561 description = lc.getDescription();
            if (description != null) {
                e.setTooltip(new class_2561[]{description});
            }
            return e.build();
        }
        throw new UnsupportedOperationException("unknown entry: " + entry.getClass().getName());
    }

    @NotNull
    private static <T extends Enum<T>> EnumListEntry<T> addEnum(ConfigBuilder builder, EnumConfigValue<T> ec) {
        EnumSelectorBuilder e = builder.entryBuilder().startEnumSelector(ec.getTranslation(), ec.getEnum(), (Enum)ec.get()).setDefaultValue((Enum)ec.getDefaultValue()).setSaveConsumer(ec::set);
        class_2561 description = ec.getDescription();
        if (description != null) {
            e.setTooltip(new class_2561[]{description});
        }
        return e.build();
    }
}

