/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.SoftFluidRegistryImpl;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidClient;
import net.mehvahdjukaar.moonlight.core.network.ClientBoundFinalizeFluidsMessage;
import net.mehvahdjukaar.moonlight.core.network.ModMessages;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class SoftFluidRegistry {
    public static final SoftFluid EMPTY = new SoftFluid.Builder(new class_2960(""), new class_2960("")).build();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        SoftFluidRegistryImpl.init();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static class_5321<class_2378<SoftFluid>> getRegistryKey() {
        return SoftFluidRegistryImpl.getRegistryKey();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<class_3611, SoftFluid> getFluidsMap() {
        return SoftFluidRegistryImpl.getFluidsMap();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Map<class_1792, SoftFluid> getItemsMap() {
        return SoftFluidRegistryImpl.getItemsMap();
    }

    public static class_2378<SoftFluid> getDataPackRegistry() {
        return Utils.hackyGetRegistryAccess().method_30530(SoftFluidRegistry.getRegistryKey());
    }

    public static Collection<SoftFluid> getValues() {
        return SoftFluidRegistry.getDataPackRegistry().method_10220().toList();
    }

    public static Set<Map.Entry<class_5321<SoftFluid>, SoftFluid>> getEntries() {
        return SoftFluidRegistry.getDataPackRegistry().method_29722();
    }

    public static SoftFluid get(String id) {
        return SoftFluidRegistry.get(new class_2960(id));
    }

    @Nullable
    public static class_2960 getID(SoftFluid s) {
        return SoftFluidRegistry.getDataPackRegistry().method_10221((Object)s);
    }

    public static SoftFluid get(class_2960 id) {
        if (id.method_12836().equals("selene")) {
            id = Moonlight.res(id.method_12832());
        }
        return (SoftFluid)SoftFluidRegistry.getDataPackRegistry().method_10223(id);
    }

    public static Optional<SoftFluid> getOptional(class_2960 id) {
        return SoftFluidRegistry.getDataPackRegistry().method_17966(id);
    }

    public static SoftFluid fromForgeFluid(class_3611 fluid) {
        return SoftFluidRegistry.getFluidsMap().getOrDefault(fluid, EMPTY);
    }

    @Nonnull
    public static SoftFluid fromItem(class_1792 filledContainerItem) {
        return SoftFluidRegistry.getItemsMap().getOrDefault(filledContainerItem, EMPTY);
    }

    private static void populateSlaveMaps() {
        Map<class_1792, SoftFluid> itemMap = SoftFluidRegistry.getItemsMap();
        Map<class_3611, SoftFluid> fluidsMap = SoftFluidRegistry.getFluidsMap();
        for (SoftFluid s : SoftFluidRegistry.getValues()) {
            if (!PlatformHelper.isModLoaded(s.getFromMod())) continue;
            s.getEquivalentFluids().forEach(f -> fluidsMap.put((class_3611)f, s));
            s.getContainerList().getPossibleFilled().forEach(i -> {
                if (i != class_1802.field_8574 || !SoftFluidRegistry.getID(s).toString().equals("minecraft:water")) {
                    itemMap.put((class_1792)i, s);
                }
            });
        }
    }

    public static void postInitClient() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidClient.refresh();
    }

    public static void onDataLoad() {
        SoftFluidRegistry.populateSlaveMaps();
        SoftFluidRegistry.addExistingVanillaFluids();
        ModMessages.CHANNEL.sendToAllClientPlayers(new ClientBoundFinalizeFluidsMessage());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void addExistingVanillaFluids() {
        SoftFluidRegistryImpl.addExistingVanillaFluids();
    }
}

