/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids;

import dev.architectury.injectables.annotations.ExpectPlatform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.fabric.ISoftFluidTankImpl;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;

public interface ISoftFluidTank {
    public static final String POTION_TYPE_KEY = "Bottle";
    public static final int BOTTLE_COUNT = 1;
    public static final int BOWL_COUNT = 2;
    public static final int BUCKET_COUNT = 4;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ISoftFluidTank create(int capacity) {
        return ISoftFluidTankImpl.create(capacity);
    }

    public boolean interactWithPlayer(class_1657 var1, class_1268 var2, @Nullable class_1937 var3, @Nullable class_2338 var4);

    @Nullable
    public class_1799 interactWithItem(class_1799 var1, @Nullable class_1937 var2, @Nullable class_2338 var3, boolean var4);

    @Nullable
    public class_1799 tryDrainItem(class_1799 var1, @Nullable class_1937 var2, @Nullable class_2338 var3, boolean var4);

    @Nullable
    public class_1799 tryFillingItem(class_1792 var1, @Nullable class_1937 var2, @Nullable class_2338 var3, boolean var4);

    @Nullable
    default public class_1799 tryFillingBottle(class_1937 world, class_2338 pos) {
        return this.tryFillingItem(class_1802.field_8469, world, pos, false);
    }

    @Nullable
    default public class_1799 tryFillingBucket(class_1937 world, class_2338 pos) {
        return this.tryFillingItem(class_1802.field_8550, world, pos, false);
    }

    @Nullable
    default public class_1799 tryFillingBowl(class_1937 world, class_2338 pos) {
        return this.tryFillingItem(class_1802.field_8428, world, pos, false);
    }

    default public boolean isSameFluidAs(SoftFluid other) {
        return this.isSameFluidAs(other, null);
    }

    default public boolean isSameFluidAs(SoftFluid other, @Nullable class_2487 com) {
        return this.getFluid().equals(other) && ISoftFluidTank.areNbtEquals(this.getNbt(), com);
    }

    public boolean tryAddingFluid(SoftFluid var1, int var2, @Nullable class_2487 var3);

    default public boolean tryAddingFluid(SoftFluid s, int count) {
        return this.tryAddingFluid(s, count, null);
    }

    default public boolean tryAddingFluid(SoftFluid s) {
        return this.tryAddingFluid(s, 1);
    }

    default public boolean tryTransferFluid(ISoftFluidTank destination) {
        return this.tryTransferFluid(destination, 1);
    }

    public boolean tryTransferFluid(ISoftFluidTank var1, int var2);

    public boolean canRemove(int var1);

    public boolean canAdd(int var1);

    default public boolean canAddSoftFluid(SoftFluid s, int count) {
        return this.canAddSoftFluid(s, count, null);
    }

    default public boolean canAddSoftFluid(SoftFluid s, int count, @Nullable class_2487 nbt) {
        return this.canAdd(count) && this.isSameFluidAs(s, nbt);
    }

    public boolean isFull();

    public boolean isEmpty();

    public void lossyAdd(int var1);

    public void setCount(int var1);

    public void fillCount();

    public void grow(int var1);

    public void shrink(int var1);

    public float getHeight(float var1);

    public int getComparatorOutput();

    public int getCount();

    @Nonnull
    public SoftFluid getFluid();

    @Nullable
    public class_2487 getNbt();

    public void setNbt(@Nullable class_2487 var1);

    public void clear();

    public void copy(ISoftFluidTank var1);

    default public void fill(SoftFluid fluid) {
        this.fill(fluid, null);
    }

    default public void fill(SoftFluid fluid, @Nullable class_2487 nbt) {
        this.setFluid(fluid, nbt);
        this.fillCount();
    }

    default public void setFluid(@NotNull SoftFluid fluid) {
        this.setFluid(fluid, null);
    }

    public void setFluid(@NotNull SoftFluid var1, @Nullable class_2487 var2);

    public int getTintColor(@Nullable class_4538 var1, @Nullable class_2338 var2);

    public int getFlowingTint(@Nullable class_4538 var1, @Nullable class_2338 var2);

    public int getParticleColor(@Nullable class_4538 var1, @Nullable class_2338 var2);

    default public boolean containsFood() {
        return this.getFluid().isFood();
    }

    public void load(class_2487 var1);

    public class_2487 save(class_2487 var1);

    public boolean tryDrinkUpFluid(class_1657 var1, class_1937 var2);

    public static boolean areNbtEquals(class_2487 nbt, class_2487 nbt1) {
        if ((nbt == null || nbt.method_33133()) && (nbt1 == null || nbt1.method_33133())) {
            return true;
        }
        if (nbt == null || nbt1 == null) {
            return false;
        }
        if (nbt1.method_10545(POTION_TYPE_KEY) && !nbt.method_10545(POTION_TYPE_KEY)) {
            class_2487 n1 = nbt1.method_10553();
            n1.method_10551(POTION_TYPE_KEY);
            return n1.equals((Object)nbt);
        }
        if (nbt.method_10545(POTION_TYPE_KEY) && !nbt1.method_10545(POTION_TYPE_KEY)) {
            class_2487 n = nbt.method_10553();
            n.method_10551(POTION_TYPE_KEY);
            return n.equals((Object)nbt1);
        }
        return nbt1.equals((Object)nbt);
    }
}

