/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.moonlight.api.resources.ResType;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class TextureCache {
    private static final Map<class_1935, Set<Pair<String, String>>> SPECIAL_TEXTURES = new HashMap<class_1935, Set<Pair<String, String>>>();
    private static final Map<class_1935, Set<String>> CACHED_TEXTURES = new HashMap<class_1935, Set<String>>();

    public static void registerSpecialTextureForBlock(class_1935 block, String ID, class_2960 texturePath) {
        SPECIAL_TEXTURES.computeIfAbsent(block, b -> new HashSet()).add(new Pair((Object)ID, (Object)ResType.TEXTURES.getPath(texturePath).toString()));
    }

    public static void refresh() {
        CACHED_TEXTURES.clear();
    }

    @Nullable
    public static String getCached(class_1935 block, Predicate<String> texturePredicate) {
        Set<String> list;
        Set<Pair<String, String>> special = SPECIAL_TEXTURES.get(block);
        if (special != null) {
            for (Pair<String, String> e : special) {
                if (!texturePredicate.test((String)e.getFirst())) continue;
                return (String)e.getSecond();
            }
        }
        if ((list = CACHED_TEXTURES.get(block)) != null) {
            for (String e : list) {
                if (!texturePredicate.test(e)) continue;
                return e;
            }
        }
        return null;
    }

    public static void add(class_1935 block, String t) {
        CACHED_TEXTURES.computeIfAbsent(block, b -> new HashSet()).add(t);
    }
}

