/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import net.minecraft.class_1074;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_5699;
import snownee.jade.Jade;
import snownee.jade.api.JadeIds;
import snownee.jade.util.JsonConfig;

public class JadeLanguages
implements class_4013 {
    public static final JadeLanguages INSTANCE = new JadeLanguages();
    public static final class_2960 ID = JadeIds.JADE("languages");
    private Map<String, Pattern> nameClasses = Map.of();
    private final Cache<String, String> nameClassCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    public void method_14491(class_3300 resourceManager) {
        this.nameClasses = Map.of();
        this.nameClassCache.invalidateAll();
        try {
            JsonObject jsonObject = (JsonObject)JsonConfig.GSON.fromJson(class_1074.method_4662((String)"jade.metadata", (Object[])new Object[0]), JsonObject.class);
            Metadata metadata = (Metadata)Metadata.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow();
            if (!metadata.lang.contains(class_310.method_1551().method_1526().method_4669())) {
                return;
            }
            this.nameClasses = metadata.nameClasses;
        }
        catch (Throwable e) {
            Jade.LOGGER.error("Failed to load Jade language metadata", e);
        }
    }

    public String getNameClass(String name) {
        if (this.nameClasses.isEmpty()) {
            return "other";
        }
        try {
            return (String)this.nameClassCache.get((Object)name, () -> {
                for (Map.Entry<String, Pattern> entry : this.nameClasses.entrySet()) {
                    if (!entry.getValue().matcher(name).matches()) continue;
                    return entry.getKey();
                }
                return "other";
            });
        }
        catch (ExecutionException e) {
            return "other";
        }
    }

    private record Metadata(List<String> lang, Map<String, Pattern> nameClasses) {
        static final Codec<Metadata> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.listOf().fieldOf("lang").forGetter(Metadata::lang), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)class_5699.field_37408).optionalFieldOf("nameClasses", Map.of()).forGetter(Metadata::nameClasses)).apply((Applicative)i, Metadata::new));
    }
}

