/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.serialization.MapDecoder;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.block.BlockPickInteractionAware;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.EntityPickInteractionAware;
import net.fabricmc.fabric.api.event.lifecycle.v1.CommonLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1074;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1534;
import net.minecraft.class_1657;
import net.minecraft.class_1772;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_1844;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2073;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_223;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_3611;
import net.minecraft.class_3852;
import net.minecraft.class_3954;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.class_8551;
import net.minecraft.class_8710;
import net.minecraft.class_9279;
import net.minecraft.class_9280;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.compat.TechRebornEnergyCompat;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.mixin.AbstractHorseAccess;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerPingPacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.util.JadeFabricUtils;
import snownee.jade.util.UsernameCache;
import snownee.jade.util.WailaExceptionHandler;
import team.reborn.energy.api.EnergyStorage;

public final class CommonProxy
implements ModInitializer {
    public static boolean hasTechRebornEnergy = CommonProxy.isModLoaded("team_reborn_energy");

    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        Optional optional = class_2631.method_59539((UUID)uuid).getNow(Optional.empty());
        if (optional.isPresent()) {
            return ((GameProfile)optional.get()).getName();
        }
        if (CommonProxy.isPhysicallyClient()) {
            return UsernameCache.getLastKnownUsername(uuid);
        }
        return null;
    }

    public static File getConfigDirectory() {
        return FabricLoader.getInstance().getConfigDir().toFile();
    }

    public static boolean isShears(class_1799 tool) {
        return tool.method_7909() instanceof class_1820 || tool.method_31573(ConventionalItemTags.SHEAR_TOOLS);
    }

    public static boolean isCorrectToolForDrops(class_2680 state, class_1657 player, class_1937 level, class_2338 pos) {
        return player.method_7305(state);
    }

    public static String getModIdFromItem(class_1799 stack) {
        class_9279 customData;
        class_1844 potionContents;
        String namespace;
        class_2960 id;
        String modid;
        String key;
        class_9280 modelData;
        if (CommonProxy.isPhysicallyClient() && !class_9280.field_49307.equals((Object)(modelData = (class_9280)stack.method_57825(class_9334.field_49637, (Object)class_9280.field_49307))) && class_1074.method_4663((String)(key = "jade.customModelData.%s.namespace".formatted(modelData.comp_2382())))) {
            return class_1074.method_4662((String)key, (Object[])new Object[0]);
        }
        if (stack.method_7909() instanceof class_1772) {
            class_9304 enchantments = (class_9304)stack.method_57825(class_9334.field_49643, (Object)class_9304.field_49385);
            modid = null;
            for (class_6880 enchantmentHolder : enchantments.method_57534()) {
                id = enchantmentHolder.method_40230().map(class_5321::method_29177).orElse(null);
                if (id == null) continue;
                namespace = id.method_12836();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if ((potionContents = (class_1844)stack.method_57825(class_9334.field_49651, (Object)class_1844.field_49274)).method_57405()) {
            modid = null;
            for (class_1293 effect : potionContents.method_57397()) {
                id = effect.method_5579().method_40230().map(class_5321::method_29177).orElse(null);
                if (id == null) continue;
                namespace = id.method_12836();
                if (modid == null) {
                    modid = namespace;
                    continue;
                }
                if (modid.equals(namespace)) continue;
                modid = null;
                break;
            }
            if (modid != null) {
                return modid;
            }
        }
        if (stack.method_31574(class_1802.field_8892) && !(customData = (class_9279)stack.method_57825(class_9334.field_49609, (Object)class_9279.field_49302)).method_57458()) {
            return customData.method_57446((MapDecoder)class_1534.field_49238).result().flatMap(class_6880::method_40230).map(class_5321::method_29177).map(class_2960::method_12836).orElse("minecraft");
        }
        return class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12836();
    }

    public static boolean isPhysicallyClient() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public static ItemCollector<?> createItemCollector(Object target, Cache<Object, ItemCollector<?>> containerCache) {
        if (target instanceof AbstractHorseAccess) {
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(o -> {
                if (o instanceof AbstractHorseAccess) {
                    AbstractHorseAccess horse = (AbstractHorseAccess)o;
                    return horse.getInventory();
                }
                return null;
            }, 2));
        }
        if (target instanceof class_2586) {
            class_2586 be = (class_2586)target;
            try {
                Storage storage = (Storage)ItemStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, null);
                if (storage != null) {
                    return (ItemCollector)containerCache.get((Object)storage, () -> new ItemCollector<Storage<ItemVariant>>(JadeFabricUtils.fromItemStorage((Storage<ItemVariant>)storage, 0)));
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null, null);
            }
        }
        if (target instanceof class_1263) {
            if (target instanceof class_2595) {
                return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(o -> {
                    if (o instanceof class_2595) {
                        class_2281 chestBlock;
                        class_1263 compound;
                        class_2595 be = (class_2595)o;
                        class_2248 patt0$temp = be.method_11010().method_26204();
                        if (patt0$temp instanceof class_2281 && (compound = class_2281.method_17458((class_2281)(chestBlock = (class_2281)patt0$temp), (class_2680)be.method_11010(), (class_1937)be.method_10997(), (class_2338)be.method_11016(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<class_1799>> containerGroup(class_1263 container, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get((Object)container, () -> new ItemCollector<class_1263>(new ItemIterator.ContainerItemIterator(0)))).update(container, accessor.getLevel().method_8510());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<class_1799>> storageGroup(Object storage, Accessor<?> accessor) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get(storage, () -> new ItemCollector<Storage<ItemVariant>>(JadeFabricUtils.fromItemStorage((Storage<ItemVariant>)((Storage)storage), 0)))).update(storage, accessor.getLevel().method_8510());
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static List<ViewGroup<class_2487>> wrapFluidStorage(Accessor<?> accessor) {
        Object object = accessor.getTarget();
        if (object instanceof class_2586) {
            class_2586 be = (class_2586)object;
            try {
                Storage storage = (Storage)FluidStorage.SIDED.find(be.method_10997(), be.method_11016(), be.method_11010(), be, null);
                if (storage != null) {
                    return JadeFabricUtils.fromFluidStorage((Storage<FluidVariant>)storage);
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null, null);
            }
        }
        return null;
    }

    public static List<ViewGroup<class_2487>> wrapEnergyStorage(Accessor<?> accessor) {
        Object object;
        if (hasTechRebornEnergy && (object = accessor.getTarget()) instanceof class_2586) {
            class_2586 be = (class_2586)object;
            try {
                EnergyStorage storage = (EnergyStorage)TechRebornEnergyCompat.getSided().find(be.method_10997(), be.method_11016(), be.method_11010(), be, null);
                if (storage != null && storage.getCapacity() > 0L) {
                    ViewGroup<class_2487> group = new ViewGroup<class_2487>(List.of(EnergyView.of(storage.getAmount(), storage.getCapacity())));
                    group.getExtraData().method_10582("Unit", "E");
                    return List.of(group);
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null, null);
            }
        }
        return null;
    }

    public static boolean isDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static float getEnchantPowerBonus(class_2680 state, class_1937 world, class_2338 pos) {
        if (WailaClientRegistration.instance().customEnchantPowers.containsKey(state.method_26204())) {
            return WailaClientRegistration.instance().customEnchantPowers.get(state.method_26204()).getEnchantPowerBonus(state, world, pos);
        }
        return state.method_27852(class_2246.field_10504) ? 1.0f : 0.0f;
    }

    public static class_2960 getId(class_2248 block) {
        return class_7923.field_41175.method_10221((Object)block);
    }

    public static class_2960 getId(class_1299<?> entityType) {
        return class_7923.field_41177.method_10221(entityType);
    }

    public static class_2960 getId(class_2591<?> blockEntityType) {
        return class_7923.field_41181.method_10221(blockEntityType);
    }

    public static String getPlatformIdentifier() {
        return "fabric";
    }

    public static class_5250 getProfessionName(class_3852 profession) {
        return class_2561.method_43471((String)(class_1299.field_6077.method_5882() + "." + class_7923.field_41195.method_10221((Object)profession).method_12832()));
    }

    private static void registerServerCommand(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        JadeServerCommand.register(dispatcher);
    }

    public static boolean isBoss(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        return entityType.method_20210(ConventionalEntityTypeTags.BOSSES) || entityType == class_1299.field_6116 || entityType == class_1299.field_6119;
    }

    public static class_1799 getBlockPickedResult(class_2680 state, class_1657 player, class_3965 hitResult) {
        class_2248 block = state.method_26204();
        if (block instanceof BlockPickInteractionAware) {
            return ((BlockPickInteractionAware)block).getPickedStack(state, (class_1922)player.method_37908(), hitResult.method_17777(), player, (class_239)hitResult);
        }
        return block.method_9574((class_4538)player.method_37908(), hitResult.method_17777(), state);
    }

    public static class_1799 getEntityPickedResult(class_1297 entity, class_1657 player, class_3966 hitResult) {
        if (entity instanceof EntityPickInteractionAware) {
            return ((EntityPickInteractionAware)entity).getPickedStack(player, (class_239)hitResult);
        }
        class_1799 stack = entity.method_31480();
        return stack == null ? class_1799.field_8037 : stack;
    }

    private static void playerJoin(class_3244 handler, PacketSender sender, MinecraftServer server) {
        class_3222 player = handler.field_14140;
        String configs = PluginConfig.INSTANCE.getServerConfigs();
        List<class_2248> shearableBlocks = HarvestToolProvider.INSTANCE.getShearableBlocks();
        if (!configs.isEmpty()) {
            Jade.LOGGER.debug("Syncing config to {} ({})", (Object)player.method_7334().getName(), (Object)player.method_7334().getId());
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new ServerPingPacket(configs, shearableBlocks));
    }

    public static boolean isModLoaded(String modid) {
        return FabricLoader.getInstance().isModLoaded(modid);
    }

    public static void loadComplete() {
        HashSet classes = Sets.newHashSet();
        FabricLoader.getInstance().getEntrypointContainers("jade", IWailaPlugin.class).forEach(entrypoint -> {
            block9: {
                String className = null;
                try {
                    ModMetadata metadata = entrypoint.getProvider().getMetadata();
                    IWailaPlugin plugin = (IWailaPlugin)entrypoint.getEntrypoint();
                    className = plugin.getClass().getName();
                    Jade.LOGGER.info("Start loading plugin from %s: %s".formatted(metadata.getName(), className));
                    WailaPlugin a = plugin.getClass().getDeclaredAnnotation(WailaPlugin.class);
                    if (a != null && !Strings.isNullOrEmpty((String)a.value()) && !CommonProxy.isModLoaded(a.value())) {
                        return;
                    }
                    if (className.startsWith("snownee.jade.") && !metadata.getId().startsWith("jade")) {
                        throw new IllegalStateException("Mod %s is not allowed to register built-in plugins. Please contact the mod author".formatted(metadata.getName()));
                    }
                    if (!classes.add(plugin.getClass())) {
                        throw new IllegalStateException("Duplicate plugin class " + className);
                    }
                    Stopwatch stopwatch = null;
                    if (CommonProxy.isDevEnv()) {
                        stopwatch = Stopwatch.createStarted();
                    }
                    WailaCommonRegistration common = WailaCommonRegistration.instance();
                    common.startSession();
                    plugin.register(common);
                    if (CommonProxy.isPhysicallyClient()) {
                        WailaClientRegistration client = WailaClientRegistration.instance();
                        client.startSession();
                        plugin.registerClient(client);
                        if (stopwatch != null) {
                            Jade.LOGGER.info("Bootstrapped plugin from %s in %s".formatted(className, stopwatch));
                        }
                        client.endSession();
                    }
                    common.endSession();
                    if (stopwatch != null) {
                        Jade.LOGGER.info("Loaded plugin from %s in %s".formatted(className, stopwatch.stop()));
                    }
                }
                catch (Throwable e) {
                    Jade.LOGGER.error("Error loading plugin at %s".formatted(className), e);
                    Throwables.throwIfInstanceOf((Throwable)e, IllegalStateException.class);
                    if (!entrypoint.getProvider().getMetadata().getId().equals("jade")) break block9;
                    throw e;
                }
            }
        });
        Jade.loadComplete();
    }

    public static class_2561 getFluidName(JadeFluidObject fluidObject) {
        class_3611 fluid = fluidObject.getType();
        class_9326 components = fluidObject.getComponents();
        return FluidVariantAttributes.getName((FluidVariant)FluidVariant.of((class_3611)fluid, (class_9326)components));
    }

    public static int showOrHideFromServer(Collection<class_3222> players, boolean show) {
        ShowOverlayPacket packet = new ShowOverlayPacket(show);
        for (class_3222 player : players) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
        return players.size();
    }

    public static boolean isMultipartEntity(class_1297 target) {
        return target instanceof class_1510;
    }

    public static class_1297 wrapPartEntityParent(class_1297 target) {
        if (target instanceof class_1508) {
            class_1508 part = (class_1508)target;
            return part.field_7007;
        }
        return target;
    }

    public static int getPartEntityIndex(class_1297 entity) {
        if (!(entity instanceof class_1508)) {
            return -1;
        }
        class_1508 part = (class_1508)entity;
        class_1297 class_12972 = CommonProxy.wrapPartEntityParent(entity);
        if (!(class_12972 instanceof class_1510)) {
            return -1;
        }
        class_1510 parent = (class_1510)class_12972;
        class_1508[] parts = parent.method_5690();
        return List.of(parts).indexOf(part);
    }

    public static class_1297 getPartEntity(class_1297 parent, int index) {
        class_1510 dragon;
        class_1508[] parts;
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        if (parent instanceof class_1510 && index < (parts = (dragon = (class_1510)parent).method_5690()).length) {
            return parts[index];
        }
        return parent;
    }

    public static boolean hasDefaultItemStorage(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            if (blockAccessor.getBlockEntity() == null) {
                return blockAccessor.getBlock() instanceof class_3954;
            }
            return ItemStorage.SIDED.find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null) != null;
        }
        return true;
    }

    public static boolean hasDefaultFluidStorage(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return FluidStorage.SIDED.find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null) != null;
        }
        return true;
    }

    public static boolean hasDefaultEnergyStorage(Accessor<?> accessor) {
        if (hasTechRebornEnergy && accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return TechRebornEnergyCompat.getSided().find(accessor.getLevel(), blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null) != null;
        }
        return true;
    }

    public static long bucketVolume() {
        return 81000L;
    }

    public static long blockVolume() {
        return 81000L;
    }

    public static void registerTagsUpdatedListener(BiConsumer<class_5455, Boolean> listener) {
        CommonLifecycleEvents.TAGS_LOADED.register(listener::accept);
    }

    public static boolean isCorrectConditions(List<class_5341> conditions, class_1799 toolItem) {
        if (conditions.size() != 1) {
            return false;
        }
        class_5341 condition = conditions.getFirst();
        if (condition instanceof class_223) {
            class_223 matchTool = (class_223)condition;
            class_2073 itemPredicate = matchTool.comp_1884().orElse(null);
            return itemPredicate != null && itemPredicate.method_8970(toolItem);
        }
        if (condition instanceof class_8551) {
            class_8551 anyOfCondition = (class_8551)condition;
            for (class_5341 child : anyOfCondition.field_1246) {
                if (!CommonProxy.isCorrectConditions(List.of(child), toolItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void onInitialize() {
        PayloadTypeRegistry.playS2C().register(ReceiveDataPacket.TYPE, ReceiveDataPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestBlockPacket.TYPE, RequestBlockPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestEntityPacket.TYPE, RequestEntityPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ServerPingPacket.TYPE, ServerPingPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(ShowOverlayPacket.TYPE, ShowOverlayPacket.CODEC);
        ServerPlayNetworking.registerGlobalReceiver(RequestEntityPacket.TYPE, (payload, context) -> RequestEntityPacket.handle(payload, () -> ((ServerPlayNetworking.Context)context).player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestBlockPacket.TYPE, (payload, context) -> RequestBlockPacket.handle(payload, () -> ((ServerPlayNetworking.Context)context).player()));
        CommandRegistrationCallback.EVENT.register(CommonProxy::registerServerCommand);
        ServerPlayConnectionEvents.JOIN.register(CommonProxy::playerJoin);
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            if (server.method_3816()) {
                CommonProxy.loadComplete();
            }
        });
    }
}

