/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.AccessorClientHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.IToggleableProvider;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.callback.JadeBeforeTooltipCollectCallback;
import snownee.jade.api.callback.JadeItemModNameCallback;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.config.IgnoreList;
import snownee.jade.api.platform.CustomEnchantPower;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.ItemView;
import snownee.jade.api.view.ProgressView;
import snownee.jade.gui.PluginsConfigScreen;
import snownee.jade.gui.config.OptionsList;
import snownee.jade.impl.BlockAccessorImpl;
import snownee.jade.impl.CallbackContainer;
import snownee.jade.impl.ClientRegistrationSession;
import snownee.jade.impl.EntityAccessorImpl;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.PriorityStore;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.config.entry.BooleanConfigEntry;
import snownee.jade.impl.config.entry.EnumConfigEntry;
import snownee.jade.impl.config.entry.FloatConfigEntry;
import snownee.jade.impl.config.entry.IntConfigEntry;
import snownee.jade.impl.config.entry.StringConfigEntry;
import snownee.jade.impl.lookup.HierarchyLookup;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeCodecs;
import snownee.jade.util.JsonConfig;

public class WailaClientRegistration
implements IWailaClientRegistration {
    private static final WailaClientRegistration INSTANCE = new WailaClientRegistration();
    public final HierarchyLookup<IComponentProvider<BlockAccessor>> blockIconProviders;
    public final HierarchyLookup<IComponentProvider<BlockAccessor>> blockComponentProviders;
    public final HierarchyLookup<IComponentProvider<EntityAccessor>> entityIconProviders;
    public final HierarchyLookup<IComponentProvider<EntityAccessor>> entityComponentProviders;
    public final Set<class_2248> hideBlocks = Sets.newHashSet();
    private ImmutableSet<class_2248> hideBlocksReloadable = ImmutableSet.of();
    public final Set<class_1299<?>> hideEntities = Sets.newHashSet();
    private ImmutableSet<class_1299<?>> hideEntitiesReloadable = ImmutableSet.of();
    public final Set<class_2248> pickBlocks = Sets.newHashSet();
    public final Set<class_1299<?>> pickEntities = Sets.newHashSet();
    public final CallbackContainer<JadeAfterRenderCallback> afterRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeRenderCallback> beforeRenderCallback = new CallbackContainer();
    public final CallbackContainer<JadeRayTraceCallback> rayTraceCallback = new CallbackContainer();
    public final CallbackContainer<JadeTooltipCollectedCallback> tooltipCollectedCallback = new CallbackContainer();
    public final CallbackContainer<JadeItemModNameCallback> itemModNameCallback = new CallbackContainer();
    public final CallbackContainer<JadeBeforeTooltipCollectCallback> beforeTooltipCollectCallback = new CallbackContainer();
    public final Map<class_2248, CustomEnchantPower> customEnchantPowers = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_1799, ItemView>> itemStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, FluidView>> fluidStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, EnergyView>> energyStorageProviders = Maps.newHashMap();
    public final Map<class_2960, IClientExtensionProvider<class_2487, ProgressView>> progressProviders = Maps.newHashMap();
    public final Set<class_2960> clientFeatures = Sets.newHashSet();
    public final Map<Class<Accessor<?>>, AccessorClientHandler<Accessor<?>>> accessorHandlers = Maps.newIdentityHashMap();
    private ClientRegistrationSession session;

    WailaClientRegistration() {
        this.blockIconProviders = new HierarchyLookup(class_2248.class);
        this.blockComponentProviders = new HierarchyLookup(class_2248.class);
        this.entityIconProviders = new HierarchyLookup(class_1297.class);
        this.entityComponentProviders = new HierarchyLookup(class_1297.class);
    }

    public static WailaClientRegistration instance() {
        return INSTANCE;
    }

    public static <T> JsonConfig<IgnoreList<T>> createIgnoreListConfig(String file, class_5321<class_2378<T>> registryKey, List<String> defaultValues) {
        List<String> values = List.copyOf(defaultValues);
        return new JsonConfig<IgnoreList<T>>("jade/" + file, JadeCodecs.ignoreList(registryKey), null, () -> {
            IgnoreList ignoreList = new IgnoreList();
            ignoreList.values = values;
            return ignoreList;
        });
    }

    @Override
    public void registerBlockIcon(IComponentProvider<BlockAccessor> provider, Class<? extends class_2248> blockClass) {
        if (this.isSessionActive()) {
            this.session.registerBlockIcon(provider, blockClass);
        } else {
            this.blockIconProviders.register(blockClass, provider);
            this.tryAddConfig(provider);
        }
    }

    @Override
    public void registerBlockComponent(IComponentProvider<BlockAccessor> provider, Class<? extends class_2248> blockClass) {
        if (this.isSessionActive()) {
            this.session.registerBlockComponent(provider, blockClass);
        } else {
            this.blockComponentProviders.register(blockClass, provider);
            this.tryAddConfig(provider);
        }
    }

    @Override
    public void registerEntityIcon(IComponentProvider<EntityAccessor> provider, Class<? extends class_1297> entityClass) {
        if (this.isSessionActive()) {
            this.session.registerEntityIcon(provider, entityClass);
        } else {
            this.entityIconProviders.register(entityClass, provider);
            this.tryAddConfig(provider);
        }
    }

    @Override
    public void registerEntityComponent(IComponentProvider<EntityAccessor> provider, Class<? extends class_1297> entityClass) {
        if (this.isSessionActive()) {
            this.session.registerEntityComponent(provider, entityClass);
        } else {
            this.entityComponentProviders.register(entityClass, provider);
            this.tryAddConfig(provider);
        }
    }

    public List<IComponentProvider<BlockAccessor>> getBlockProviders(class_2248 block, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.blockComponentProviders.get(block).stream().filter(filter).toList();
    }

    public List<IComponentProvider<BlockAccessor>> getBlockIconProviders(class_2248 block, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.blockIconProviders.get(block).stream().filter(filter).toList();
    }

    public List<IComponentProvider<EntityAccessor>> getEntityProviders(class_1297 entity, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.entityComponentProviders.get(entity).stream().filter(filter).toList();
    }

    public List<IComponentProvider<EntityAccessor>> getEntityIconProviders(class_1297 entity, Predicate<IComponentProvider<? extends Accessor<?>>> filter) {
        return this.entityIconProviders.get(entity).stream().filter(filter).toList();
    }

    @Override
    public void hideTarget(class_2248 block) {
        Objects.requireNonNull(block);
        this.hideBlocks.add(block);
    }

    @Override
    public void hideTarget(class_1299<?> entityType) {
        Objects.requireNonNull(entityType);
        this.hideEntities.add(entityType);
    }

    @Override
    public void usePickedResult(class_2248 block) {
        Objects.requireNonNull(block);
        this.pickBlocks.add(block);
    }

    @Override
    public void usePickedResult(class_1299<?> entityType) {
        Objects.requireNonNull(entityType);
        this.pickEntities.add(entityType);
    }

    @Override
    public boolean shouldHide(class_2680 state) {
        return this.hideBlocksReloadable.contains((Object)state.method_26204());
    }

    @Override
    public boolean shouldPick(class_2680 state) {
        return this.pickBlocks.contains(state.method_26204());
    }

    @Override
    public boolean shouldHide(class_1297 entity) {
        return this.hideEntitiesReloadable.contains((Object)entity.method_5864());
    }

    @Override
    public boolean shouldPick(class_1297 entity) {
        return this.pickEntities.contains(entity.method_5864());
    }

    @Override
    public void addConfig(class_2960 key, boolean defaultValue) {
        if (this.isSessionActive()) {
            this.session.addConfig(key, defaultValue);
        } else {
            PluginConfig.INSTANCE.addConfig(new BooleanConfigEntry(key, defaultValue));
        }
    }

    @Override
    public <T extends Enum<T>> void addConfig(class_2960 key, T defaultValue) {
        Objects.requireNonNull(defaultValue);
        if (this.isSessionActive()) {
            this.session.addConfig(key, defaultValue);
        } else {
            PluginConfig.INSTANCE.addConfig(new EnumConfigEntry<T>(key, defaultValue));
        }
    }

    @Override
    public void addConfig(class_2960 key, String defaultValue, Predicate<String> validator) {
        Objects.requireNonNull(defaultValue);
        Objects.requireNonNull(validator);
        if (this.isSessionActive()) {
            this.session.addConfig(key, defaultValue, validator);
        } else {
            PluginConfig.INSTANCE.addConfig(new StringConfigEntry(key, defaultValue, validator));
        }
    }

    @Override
    public void addConfig(class_2960 key, int defaultValue, int min, int max, boolean slider) {
        if (this.isSessionActive()) {
            this.session.addConfig(key, defaultValue, min, max, slider);
        } else {
            PluginConfig.INSTANCE.addConfig(new IntConfigEntry(key, defaultValue, min, max, slider));
        }
    }

    @Override
    public void addConfig(class_2960 key, float defaultValue, float min, float max, boolean slider) {
        if (this.isSessionActive()) {
            this.session.addConfig(key, defaultValue, min, max, slider);
        } else {
            PluginConfig.INSTANCE.addConfig(new FloatConfigEntry(key, defaultValue, min, max, slider));
        }
    }

    @Override
    public void addConfigListener(class_2960 key, Consumer<class_2960> listener) {
        Objects.requireNonNull(listener);
        if (this.isSessionActive()) {
            this.session.addConfigListener(key, listener);
        } else {
            PluginConfig.INSTANCE.addConfigListener(key, listener);
        }
    }

    @Override
    public void setConfigCategoryOverride(class_2960 key, class_2561 override) {
        if (this.isSessionActive()) {
            this.session.setConfigCategoryOverride(key, override);
        } else {
            PluginConfig.INSTANCE.setCategoryOverride(key, override);
        }
    }

    @Override
    public void setConfigCategoryOverride(class_2960 key, List<class_2561> overrides) {
        if (this.isSessionActive()) {
            this.session.setConfigCategoryOverride(key, overrides);
        } else {
            PluginConfig.INSTANCE.setCategoryOverride(key, overrides);
        }
    }

    private void tryAddConfig(IToggleableProvider provider) {
        if (!provider.isRequired() && !PluginConfig.INSTANCE.containsKey(provider.getUid())) {
            this.addConfig(provider.getUid(), provider.enabledByDefault());
        }
    }

    public void loadComplete() {
        this.reloadIgnoreLists();
        PriorityStore<class_2960, IJadeProvider> priorities = WailaCommonRegistration.instance().priorities;
        this.blockComponentProviders.loadComplete(priorities);
        this.blockIconProviders.loadComplete(priorities);
        this.entityComponentProviders.loadComplete(priorities);
        this.entityIconProviders.loadComplete(priorities);
        Stream.of(this.afterRenderCallback, this.beforeRenderCallback, this.rayTraceCallback, this.tooltipCollectedCallback, this.itemModNameCallback, this.beforeTooltipCollectCallback).forEach(CallbackContainer::sort);
        this.session = null;
    }

    public synchronized void reloadIgnoreLists() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.hideEntities);
        WailaClientRegistration.createIgnoreListConfig("hide-entities", class_7924.field_41266, List.of("area_effect_cloud", "firework_rocket", "interaction", "text_display", "lightning_bolt")).get().reload((class_2378<class_1299>)class_7923.field_41177, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.hideEntitiesReloadable = builder.build();
        builder = ImmutableSet.builder();
        builder.addAll(this.hideBlocks);
        WailaClientRegistration.createIgnoreListConfig("hide-blocks", class_7924.field_41254, List.of("barrier")).get().reload((class_2378<class_2248>)class_7923.field_41175, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        this.hideBlocksReloadable = builder.build();
    }

    @Override
    public void addAfterRenderCallback(int priority, JadeAfterRenderCallback callback) {
        Objects.requireNonNull(callback);
        if (this.isSessionActive()) {
            this.session.addAfterRenderCallback(priority, callback);
        } else {
            this.afterRenderCallback.add(priority, callback);
        }
    }

    @Override
    public void addBeforeRenderCallback(int priority, JadeBeforeRenderCallback callback) {
        Objects.requireNonNull(callback);
        if (this.isSessionActive()) {
            this.session.addBeforeRenderCallback(priority, callback);
        } else {
            this.beforeRenderCallback.add(priority, callback);
        }
    }

    @Override
    public void addRayTraceCallback(int priority, JadeRayTraceCallback callback) {
        Objects.requireNonNull(callback);
        if (this.isSessionActive()) {
            this.session.addRayTraceCallback(priority, callback);
        } else {
            this.rayTraceCallback.add(priority, callback);
        }
    }

    @Override
    public void addTooltipCollectedCallback(int priority, JadeTooltipCollectedCallback callback) {
        Objects.requireNonNull(callback);
        if (this.isSessionActive()) {
            this.session.addTooltipCollectedCallback(priority, callback);
        } else {
            this.tooltipCollectedCallback.add(priority, callback);
        }
    }

    @Override
    public void addItemModNameCallback(int priority, JadeItemModNameCallback callback) {
        Objects.requireNonNull(callback);
        if (this.isSessionActive()) {
            this.session.addItemModNameCallback(priority, callback);
        } else {
            this.itemModNameCallback.add(priority, callback);
        }
    }

    @Override
    public void addBeforeTooltipCollectCallback(int priority, JadeBeforeTooltipCollectCallback callback) {
        Objects.requireNonNull(callback);
        if (this.isSessionActive()) {
            this.session.addBeforeTooltipCollectCallback(priority, callback);
        } else {
            this.beforeTooltipCollectCallback.add(priority, callback);
        }
    }

    @Override
    public BlockAccessor.Builder blockAccessor() {
        class_310 mc = class_310.method_1551();
        return new BlockAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public EntityAccessor.Builder entityAccessor() {
        class_310 mc = class_310.method_1551();
        return new EntityAccessorImpl.Builder().level((class_1937)mc.field_1687).player((class_1657)mc.field_1724).serverConnected(this.isServerConnected()).serverData(this.getServerData()).showDetails(this.isShowDetailsPressed());
    }

    @Override
    public void registerCustomEnchantPower(class_2248 block, CustomEnchantPower customEnchantPower) {
        this.customEnchantPowers.put(block, customEnchantPower);
    }

    @Override
    public class_437 createPluginConfigScreen(@Nullable class_437 parent, @Nullable class_2561 jumpToCategory) {
        Function<OptionsList, OptionsList.Entry> jumpTo = null;
        if (jumpToCategory != null) {
            String title = jumpToCategory.getString();
            jumpTo = options -> {
                for (OptionsList.Entry entry : options.method_25396()) {
                    OptionsList.Title e;
                    if (!(entry instanceof OptionsList.Title) || !(e = (OptionsList.Title)entry).getTitle().getString().equals(title)) continue;
                    return entry;
                }
                return null;
            };
        }
        return PluginsConfigScreen.createPluginConfigScreen(parent, jumpTo, false);
    }

    @Override
    public void registerItemStorageClient(IClientExtensionProvider<class_1799, ItemView> provider) {
        Objects.requireNonNull(provider.getUid());
        if (this.isSessionActive()) {
            this.session.registerItemStorageClient(provider);
        } else {
            this.itemStorageProviders.put(provider.getUid(), provider);
        }
    }

    @Override
    public void registerFluidStorageClient(IClientExtensionProvider<class_2487, FluidView> provider) {
        Objects.requireNonNull(provider.getUid());
        if (this.isSessionActive()) {
            this.session.registerFluidStorageClient(provider);
        } else {
            this.fluidStorageProviders.put(provider.getUid(), provider);
        }
    }

    @Override
    public void registerEnergyStorageClient(IClientExtensionProvider<class_2487, EnergyView> provider) {
        Objects.requireNonNull(provider.getUid());
        if (this.isSessionActive()) {
            this.session.registerEnergyStorageClient(provider);
        } else {
            this.energyStorageProviders.put(provider.getUid(), provider);
        }
    }

    @Override
    public void registerProgressClient(IClientExtensionProvider<class_2487, ProgressView> provider) {
        Objects.requireNonNull(provider.getUid());
        if (this.isSessionActive()) {
            this.session.registerProgressClient(provider);
        } else {
            this.progressProviders.put(provider.getUid(), provider);
        }
    }

    @Override
    public boolean isServerConnected() {
        return ObjectDataCenter.serverConnected;
    }

    @Override
    public boolean isShowDetailsPressed() {
        return ClientProxy.isShowDetailsPressed();
    }

    @Override
    public class_2487 getServerData() {
        return ObjectDataCenter.getServerData();
    }

    @Override
    public void setServerData(class_2487 tag) {
        ObjectDataCenter.setServerData(tag);
    }

    @Override
    public class_1799 getBlockCamouflage(class_1936 level, class_2338 pos) {
        return DatapackBlockManager.getFakeBlock(level, pos);
    }

    @Override
    public void markAsClientFeature(class_2960 uid) {
        this.clientFeatures.add(uid);
    }

    @Override
    public void markAsServerFeature(class_2960 uid) {
        this.clientFeatures.remove(uid);
    }

    @Override
    public boolean isClientFeature(class_2960 uid) {
        return this.clientFeatures.contains(uid);
    }

    @Override
    public <T extends Accessor<?>> void registerAccessorHandler(Class<T> clazz, AccessorClientHandler<T> handler) {
        this.accessorHandlers.put(clazz, handler);
    }

    @Override
    public AccessorClientHandler<Accessor<?>> getAccessorHandler(Class<? extends Accessor<?>> clazz) {
        return Objects.requireNonNull(this.accessorHandlers.get(clazz), () -> "No accessor handler for " + String.valueOf(clazz));
    }

    @Override
    public boolean maybeLowVisionUser() {
        return ClientProxy.maybeLowVisionUser || IWailaConfig.get().getGeneral().shouldEnableTextToSpeech();
    }

    public void startSession() {
        if (this.session == null) {
            this.session = new ClientRegistrationSession(this);
        }
        this.session.reset();
    }

    public void endSession() {
        Preconditions.checkState((this.session != null ? 1 : 0) != 0, (Object)"Session not started");
        this.session.end();
    }

    public boolean isSessionActive() {
        return this.session != null && this.session.isActive();
    }
}

