/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config.value;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_6384;
import snownee.jade.gui.config.OptionsList;

public abstract class OptionValue<T>
extends OptionsList.Entry {
    private static final class_2561 SERVER_FEATURE = class_2561.method_43470((String)"*").method_27692(class_124.field_1080);
    protected final Consumer<T> setter;
    private final class_2561 title;
    protected class_2960 id;
    public boolean serverFeature;
    protected T value;
    protected int indent;
    private int x;

    public OptionValue(String optionName, Consumer<T> setter) {
        this.title = OptionValue.makeTitle(optionName);
        this.setter = setter;
        this.addMessage(this.title.getString());
        this.addMessageKey(optionName);
        String key = OptionValue.makeKey(optionName + "_desc");
        if (class_1074.method_4663((String)key)) {
            this.appendDescription((class_2561)class_2561.method_43471((String)key));
        }
    }

    @Override
    public final void method_25343(class_332 guiGraphics, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        class_339 widget = this.getFirstWidget();
        class_2561 title0 = widget.field_22763 ? this.title : this.title.method_27661().method_27695(new class_124[]{class_124.field_1055, class_124.field_1080});
        int left = rowLeft + this.indent + 10;
        int n = rowTop + height / 2;
        Objects.requireNonNull(this.client.field_1772);
        int top = n - 9 / 2;
        guiGraphics.method_27535(this.client.field_1772, title0, left, top, 0xFFFFFF);
        if (this.serverFeature) {
            guiGraphics.method_27535(this.client.field_1772, SERVER_FEATURE, left + this.getTextWidth() + 1, top, 0xFFFFFF);
        }
        super.method_25343(guiGraphics, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        this.x = rowLeft;
    }

    public void save() {
        this.setter.accept(this.value);
    }

    public class_2561 getTitle() {
        return this.title;
    }

    public void appendDescription(class_2561 description) {
        if (this.description.isEmpty()) {
            this.description = Lists.newArrayList((Object[])new class_2561[]{description});
        } else {
            this.description.add(description);
        }
        this.addMessage(description.getString());
    }

    public int getX() {
        return this.x;
    }

    @Override
    public int getTextX(int width) {
        return this.getX() + this.indent + 10;
    }

    @Override
    public int getTextWidth() {
        return this.client.field_1772.method_27525((class_5348)this.getTitle());
    }

    public void method_37024(class_6382 output) {
        super.method_37024(output);
        if (!this.description.isEmpty()) {
            output.method_37032(class_6381.field_33790, class_6384.method_37037((List)this.description));
        }
    }

    public boolean isValidValue() {
        return true;
    }

    @Override
    public OptionsList.Entry parent(OptionsList.Entry parent) {
        super.parent(parent);
        if (parent instanceof OptionValue) {
            this.indent = ((OptionValue)parent).indent + 12;
        }
        return this;
    }

    public abstract void setValue(T var1);

    public void setId(class_2960 id) {
        this.id = id;
    }

    @Override
    public List<class_2561> getDescriptionOnShift() {
        if (this.id == null) {
            return List.of();
        }
        return List.of(class_2561.method_43470((String)this.id.toString()).method_27692(class_124.field_1080));
    }
}

