/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_9279;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.api.view.ViewGroup;

public class ItemCollector<T> {
    public static final int MAX_SIZE = 54;
    public static final ItemCollector<?> EMPTY = new ItemCollector(null);
    private static final Predicate<class_1799> NON_EMPTY = stack -> {
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_57826(class_9334.field_49637)) {
            class_9279 customData = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 tag = customData.method_57463();
            for (String key : tag.method_10541()) {
                if (!key.toLowerCase(Locale.ENGLISH).endsWith("clear") || !tag.method_10577(key)) continue;
                return false;
            }
        }
        return true;
    };
    private final Object2IntLinkedOpenHashMap<ItemDefinition> items = new Object2IntLinkedOpenHashMap();
    private final ItemIterator<T> iterator;
    public long version;
    public long lastTimeFinished;
    public List<ViewGroup<class_1799>> mergedResult;

    public ItemCollector(ItemIterator<T> iterator) {
        this.iterator = iterator;
    }

    public List<ViewGroup<class_1799>> update(Object target, long gameTime) {
        if (this.iterator == null) {
            return null;
        }
        T container = this.iterator.find(target);
        if (container == null) {
            return null;
        }
        long currentVersion = this.iterator.getVersion(container);
        if (this.mergedResult != null && this.iterator.isFinished()) {
            if (this.version == currentVersion) {
                return this.mergedResult;
            }
            if (this.lastTimeFinished + 5L > gameTime) {
                return this.mergedResult;
            }
            this.iterator.reset();
        }
        AtomicInteger count = new AtomicInteger();
        this.iterator.populate(container).forEach(stack -> {
            count.incrementAndGet();
            if (NON_EMPTY.test((class_1799)stack)) {
                ItemDefinition def = new ItemDefinition((class_1799)stack);
                this.items.addTo((Object)def, stack.method_7947());
            }
        });
        this.iterator.afterPopulate(count.get());
        if (this.mergedResult != null && !this.iterator.isFinished()) {
            this.updateCollectingProgress(this.mergedResult.getFirst());
            return this.mergedResult;
        }
        List<class_1799> partialResult = this.items.object2IntEntrySet().stream().limit(54L).map(entry -> {
            ItemDefinition def = (ItemDefinition)entry.getKey();
            return def.toStack(entry.getIntValue());
        }).toList();
        List<ViewGroup<class_1799>> groups = List.of(this.updateCollectingProgress(new ViewGroup<class_1799>(partialResult)));
        if (this.iterator.isFinished()) {
            this.mergedResult = groups;
            this.version = currentVersion;
            this.lastTimeFinished = gameTime;
            this.items.clear();
        }
        return groups;
    }

    protected ViewGroup<class_1799> updateCollectingProgress(ViewGroup<class_1799> group) {
        float progress = this.iterator.getCollectingProgress();
        class_2487 data = group.getExtraData();
        if (Float.isNaN(progress)) {
            progress = 0.0f;
        }
        if (progress >= 1.0f) {
            data.method_10551("Collecting");
        } else {
            data.method_10548("Collecting", progress);
        }
        return group;
    }

    public record ItemDefinition(class_1792 item, class_9326 components) {
        ItemDefinition(class_1799 stack) {
            this(stack.method_7909(), stack.method_57380());
        }

        public class_1799 toStack(int count) {
            class_1799 itemStack = new class_1799((class_1935)this.item, count);
            itemStack.method_57366(this.components);
            return itemStack;
        }
    }
}

