/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.gui.config;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class NotUglyEditBox
extends AbstractWidget
implements Renderable {
    private final Font font;
    public int paddingLeft;
    public int paddingRight;
    public int paddingTop;
    @Nullable
    public Consumer<String> responder;
    private String value = "";
    private int maxLength = 32;
    private int frame;
    private boolean canLoseFocus = true;
    private boolean isEditable = true;
    private boolean shiftPressed;
    private int displayPos;
    private int cursorPos;
    private int highlightPos;
    private int textColor = 0xE0E0E0;
    private int textColorUneditable = 0x707070;
    @Nullable
    private String suggestion;
    private Predicate<String> filter = Objects::nonNull;
    private BiFunction<String, Integer, FormattedCharSequence> formatter = (string, integer) -> FormattedCharSequence.m_13714_((String)string, (Style)Style.f_131099_);
    @Nullable
    private Component hint;
    private boolean isMouseOverCross;

    public NotUglyEditBox(Font font, int i, int j, int k, int l, Component component) {
        this(font, i, j, k, l, null, component);
    }

    public NotUglyEditBox(Font font, int i, int j, int k, int l, @Nullable NotUglyEditBox editBox, Component component) {
        super(i, j, k, l, component);
        this.font = font;
        if (editBox != null) {
            this.setValue(editBox.getValue());
        }
    }

    public void setFormatter(BiFunction<String, Integer, FormattedCharSequence> biFunction) {
        this.formatter = biFunction;
    }

    public void tick() {
        ++this.frame;
    }

    protected MutableComponent m_5646_() {
        Component component = this.m_6035_();
        String value = this.isMouseOverCross ? "" : this.value;
        return Component.m_237110_((String)"gui.narrate.editBox", (Object[])new Object[]{component, value});
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        if (!this.filter.test(string)) {
            return;
        }
        this.value = string.length() > this.maxLength ? string.substring(0, this.maxLength) : string;
        this.moveCursorToEnd();
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(string);
    }

    public String getHighlighted() {
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        return this.value.substring(i, j);
    }

    public void setFilter(Predicate<String> predicate) {
        this.filter = predicate;
    }

    public void insertText(String string) {
        String string3;
        String string2;
        int l;
        int i = Math.min(this.cursorPos, this.highlightPos);
        int j = Math.max(this.cursorPos, this.highlightPos);
        int k = this.maxLength - this.value.length() - (i - j);
        if (k < (l = (string2 = SharedConstants.m_136190_((String)string)).length())) {
            string2 = string2.substring(0, k);
            l = k;
        }
        if (!this.filter.test(string3 = new StringBuilder(this.value).replace(i, j, string2).toString())) {
            return;
        }
        this.value = string3;
        this.setCursorPosition(i + l);
        this.setHighlightPos(this.cursorPos);
        this.onValueChange(this.value);
    }

    private void onValueChange(String string) {
        if (this.responder != null) {
            this.responder.accept(string);
        }
    }

    private void deleteText(int i) {
        if (Screen.m_96637_()) {
            this.deleteWords(i);
        } else {
            this.deleteChars(i);
        }
    }

    public void deleteWords(int i) {
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        this.deleteChars(this.getWordPosition(i) - this.cursorPos);
    }

    public void deleteChars(int i) {
        int l;
        if (this.value.isEmpty()) {
            return;
        }
        if (this.highlightPos != this.cursorPos) {
            this.insertText("");
            return;
        }
        int j = this.getCursorPos(i);
        int k = Math.min(j, this.cursorPos);
        if (k == (l = Math.max(j, this.cursorPos))) {
            return;
        }
        String string = new StringBuilder(this.value).delete(k, l).toString();
        if (!this.filter.test(string)) {
            return;
        }
        this.value = string;
        this.moveCursorTo(k);
    }

    public int getWordPosition(int i) {
        return this.getWordPosition(i, this.getCursorPosition());
    }

    private int getWordPosition(int i, int j) {
        return this.getWordPosition(i, j, true);
    }

    private int getWordPosition(int i, int j, boolean bl) {
        int k = j;
        boolean bl2 = i < 0;
        int l = Math.abs(i);
        for (int m = 0; m < l; ++m) {
            if (bl2) {
                while (bl && k > 0 && this.value.charAt(k - 1) == ' ') {
                    --k;
                }
                while (k > 0 && this.value.charAt(k - 1) != ' ') {
                    --k;
                }
                continue;
            }
            int n = this.value.length();
            if ((k = this.value.indexOf(32, k)) == -1) {
                k = n;
                continue;
            }
            while (bl && k < n && this.value.charAt(k) == ' ') {
                ++k;
            }
        }
        return k;
    }

    public void moveCursor(int i) {
        this.moveCursorTo(this.getCursorPos(i));
    }

    private int getCursorPos(int i) {
        return Util.m_137479_((String)this.value, (int)this.cursorPos, (int)i);
    }

    public void moveCursorTo(int i) {
        this.setCursorPosition(i);
        if (!this.shiftPressed) {
            this.setHighlightPos(this.cursorPos);
        }
        this.onValueChange(this.value);
    }

    public void moveCursorToStart() {
        this.moveCursorTo(0);
    }

    public void moveCursorToEnd() {
        this.moveCursorTo(this.value.length());
    }

    public boolean m_7933_(int i, int j, int k) {
        if (!this.canConsumeInput()) {
            return false;
        }
        this.shiftPressed = Screen.m_96638_();
        if (Screen.m_96634_((int)i)) {
            this.moveCursorToEnd();
            this.setHighlightPos(0);
            return true;
        }
        if (Screen.m_96632_((int)i)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            return true;
        }
        if (Screen.m_96630_((int)i)) {
            if (this.isEditable) {
                this.insertText(Minecraft.m_91087_().f_91068_.m_90876_());
            }
            return true;
        }
        if (Screen.m_96628_((int)i)) {
            Minecraft.m_91087_().f_91068_.m_90911_(this.getHighlighted());
            if (this.isEditable) {
                this.insertText("");
            }
            return true;
        }
        switch (i) {
            case 263: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(-1));
                } else {
                    this.moveCursor(-1);
                }
                return true;
            }
            case 262: {
                if (Screen.m_96637_()) {
                    this.moveCursorTo(this.getWordPosition(1));
                } else {
                    this.moveCursor(1);
                }
                return true;
            }
            case 259: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(-1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 261: {
                if (this.isEditable) {
                    this.shiftPressed = false;
                    this.deleteText(1);
                    this.shiftPressed = Screen.m_96638_();
                }
                return true;
            }
            case 268: {
                this.moveCursorToStart();
                return true;
            }
            case 269: {
                this.moveCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.isVisible() && this.m_93696_() && this.isEditable();
    }

    public boolean m_5534_(char c, int i) {
        if (!this.canConsumeInput()) {
            return false;
        }
        if (SharedConstants.m_136188_((char)c)) {
            if (this.isEditable) {
                this.insertText(Character.toString(c));
            }
            return true;
        }
        return false;
    }

    public void m_5716_(double x, double y) {
        if (this.isMouseOverCross) {
            this.setValue("");
            super.m_7435_(Minecraft.m_91087_().m_91106_());
            return;
        }
        int i = Mth.m_14107_((double)x) - this.m_252754_() - this.paddingLeft;
        String string = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
        this.moveCursorTo(this.font.m_92834_(string, i).length() + this.displayPos);
    }

    public void m_7435_(SoundManager soundManager) {
    }

    protected void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
    }

    public void m_87963_(GuiGraphics guiGraphics, int i, int j, float f) {
        this.isMouseOverCross = false;
        if (!this.isVisible()) {
            return;
        }
        this.renderBackground(guiGraphics, i, j, f);
        if (this.isEditable && !this.value.isEmpty()) {
            this.isMouseOverCross = this.f_93622_ && i > this.f_93618_ - this.paddingRight + 4;
            int c = this.isMouseOverCross ? this.textColor : this.textColorUneditable;
            guiGraphics.m_280488_(this.font, "\u00d7", this.m_252754_() + this.f_93618_ - 10, this.m_252907_() + this.paddingTop + 1, c);
        }
        int k = this.isEditable ? this.textColor : this.textColorUneditable;
        int l = this.cursorPos - this.displayPos;
        int m = this.highlightPos - this.displayPos;
        String string = this.font.m_92834_(this.value.substring(this.displayPos), this.getInnerWidth());
        boolean bl = l >= 0 && l <= string.length();
        boolean bl2 = this.m_93696_() && this.frame / 6 % 2 == 0 && bl;
        int n = this.m_252754_() + this.paddingLeft;
        int o = this.m_252907_() + this.paddingTop;
        int p = n;
        if (m > string.length()) {
            m = string.length();
        }
        if (!string.isEmpty()) {
            String string2 = bl ? string.substring(0, l) : string;
            p = guiGraphics.m_280648_(this.font, this.formatter.apply(string2, this.displayPos), p, o, k);
        }
        boolean bl3 = this.cursorPos < this.value.length() || this.value.length() >= this.getMaxLength();
        int q = p;
        if (!bl) {
            q = l > 0 ? n + this.f_93618_ : n;
        } else if (bl3) {
            --q;
            --p;
        }
        if (!string.isEmpty() && bl && l < string.length()) {
            guiGraphics.m_280648_(this.font, this.formatter.apply(string.substring(l), this.cursorPos), p, o, k);
        }
        if (this.hint != null && string.isEmpty() && !this.m_93696_()) {
            guiGraphics.m_280430_(this.font, this.hint, p, o, 0x808080);
        }
        if (!bl3 && this.suggestion != null) {
            guiGraphics.m_280488_(this.font, this.suggestion, q - 1, o, -8355712);
        }
        if (bl2) {
            RenderType renderType = RenderType.m_286086_();
            Objects.requireNonNull(this.font);
            guiGraphics.m_285944_(renderType, q, o - 1, q + 1, o + 1 + 9, -3092272);
        }
        if (m != l) {
            int r = n + this.font.m_92895_(string.substring(0, m));
            Objects.requireNonNull(this.font);
            this.renderHighlight(guiGraphics, q, o - 1, r - 1, o + 1 + 9);
        }
    }

    private void renderHighlight(GuiGraphics guiGraphics, int i, int j, int k, int l) {
        int m;
        if (i < k) {
            m = i;
            i = k;
            k = m;
        }
        if (j < l) {
            m = j;
            j = l;
            l = m;
        }
        if (k > this.m_252754_() + this.f_93618_) {
            k = this.m_252754_() + this.f_93618_;
        }
        if (i > this.m_252754_() + this.f_93618_) {
            i = this.m_252754_() + this.f_93618_;
        }
        guiGraphics.m_285944_(RenderType.m_285783_(), i, j, k, l, -16776961);
    }

    private int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int i) {
        this.maxLength = i;
        if (this.value.length() > i) {
            this.value = this.value.substring(0, i);
            this.onValueChange(this.value);
        }
    }

    public int getCursorPosition() {
        return this.cursorPos;
    }

    public void setCursorPosition(int i) {
        this.cursorPos = Mth.m_14045_((int)i, (int)0, (int)this.value.length());
    }

    public void setTextColor(int i) {
        this.textColor = i;
    }

    public void setTextColorUneditable(int i) {
        this.textColorUneditable = i;
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
        if (!this.f_93624_ || !this.isEditable) {
            return null;
        }
        return super.m_264064_(focusNavigationEvent);
    }

    public boolean m_5953_(double d, double e) {
        return this.f_93624_ && d >= (double)this.m_252754_() && d < (double)(this.m_252754_() + this.f_93618_) && e >= (double)this.m_252907_() && e < (double)(this.m_252907_() + this.f_93619_);
    }

    public void m_93692_(boolean bl) {
        if (!this.canLoseFocus && !bl) {
            return;
        }
        super.m_93692_(bl);
        if (bl) {
            this.frame = 0;
        }
    }

    private boolean isEditable() {
        return this.isEditable;
    }

    public void setEditable(boolean bl) {
        this.isEditable = bl;
    }

    public int getInnerWidth() {
        return this.f_93618_ - this.paddingLeft - this.paddingRight;
    }

    public void setHighlightPos(int i) {
        int j = this.value.length();
        this.highlightPos = Mth.m_14045_((int)i, (int)0, (int)j);
        if (this.font != null) {
            if (this.displayPos > j) {
                this.displayPos = j;
            }
            int k = this.getInnerWidth();
            String string = this.font.m_92834_(this.value.substring(this.displayPos), k);
            int l = string.length() + this.displayPos;
            if (this.highlightPos == this.displayPos) {
                this.displayPos -= this.font.m_92837_(this.value, k, true).length();
            }
            if (this.highlightPos > l) {
                this.displayPos += this.highlightPos - l;
            } else if (this.highlightPos <= this.displayPos) {
                this.displayPos -= this.displayPos - this.highlightPos;
            }
            this.displayPos = Mth.m_14045_((int)this.displayPos, (int)0, (int)j);
        }
    }

    public void setCanLoseFocus(boolean bl) {
        this.canLoseFocus = bl;
    }

    public boolean isVisible() {
        return this.f_93624_;
    }

    public void setVisible(boolean bl) {
        this.f_93624_ = bl;
    }

    public void setSuggestion(@Nullable String string) {
        this.suggestion = string;
    }

    public int getScreenX(int i) {
        if (i > this.value.length()) {
            return this.m_252754_();
        }
        return this.m_252754_() + this.font.m_92895_(this.value.substring(0, i));
    }

    public void m_168797_(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
        if (this.isMouseOverCross) {
            narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.jade.clear_content.usage"));
        }
    }

    public void setHint(Component component) {
        this.hint = component;
    }
}

