/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EnchantmentTableBlock;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.util.CommonProxy;

public enum TotalEnchantmentPowerProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Level world = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        float power = 0.0f;
        for (BlockPos blockpos : EnchantmentTableBlock.f_207902_) {
            if (!EnchantmentTableBlock.m_207909_((Level)world, (BlockPos)pos, (BlockPos)blockpos)) continue;
            power += TotalEnchantmentPowerProvider.getPower(world, pos.m_121955_((Vec3i)blockpos));
        }
        if (power > 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"jade.ench_power", (Object[])new Object[]{IThemeHelper.get().info(DisplayHelper.dfCommas.format(power))}));
        }
    }

    public static float getPower(Level world, BlockPos pos) {
        return CommonProxy.getEnchantPowerBonus(world.m_8055_(pos), world, pos);
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_TOTAL_ENCHANTMENT_POWER;
    }

    @Override
    public int getDefaultPriority() {
        return -400;
    }
}

