/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.frog.Tadpole;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public enum MobGrowthProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!accessor.getServerData().m_128425_("GrowingTime", 3)) {
            return;
        }
        int time = accessor.getServerData().m_128451_("GrowingTime");
        if (time > 0) {
            tooltip.add((Component)Component.m_237110_((String)"jade.mobgrowth.time", (Object[])new Object[]{IThemeHelper.get().seconds(time)}));
        }
    }

    @Override
    public void appendServerData(CompoundTag tag, EntityAccessor accessor) {
        int time = -1;
        Entity entity = accessor.getEntity();
        if (entity instanceof AgeableMob) {
            AgeableMob ageable = (AgeableMob)entity;
            time = -ageable.m_146764_();
        } else if (entity instanceof Tadpole) {
            Tadpole tadpole = (Tadpole)entity;
            time = tadpole.m_218723_();
        }
        if (time > 0) {
            tag.m_128405_("GrowingTime", time);
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.MC_MOB_GROWTH;
    }
}

