/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ProgressView;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.ui.HorizontalLineElement;
import snownee.jade.impl.ui.ScaledTextElement;

public enum ProgressProvider implements IBlockComponentProvider,
IServerDataProvider<class_2586>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ProgressProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 data, class_3222 player, class_1937 world, class_2586 tile, boolean showDetails) {
        ProgressProvider.putData(data, player, tile, showDetails);
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.UNIVERSAL_PROGRESS;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (accessor.getServerData().method_10545("JadeProgress")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeProgressUid"))).map(WailaClientRegistration.INSTANCE.progressProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeProgress", Function.identity()));
                if (groups.isEmpty()) {
                    return;
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                BoxStyle box = new BoxStyle();
                box.bgColor = -2013265920;
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        if (group.title != null) {
                            theTooltip.add(new HorizontalLineElement());
                            theTooltip.append(new ScaledTextElement(group.title, 0.5f));
                            theTooltip.append(new HorizontalLineElement());
                        } else if (group.bgColor == 0) {
                            theTooltip.add(new HorizontalLineElement());
                        }
                    }
                    for (ProgressView view : group.views) {
                        if (view.text != null) {
                            theTooltip.add(new ScaledTextElement(view.text, 0.75f));
                        }
                        theTooltip.add(helper.progress(view.progress, null, view.style, box, false).size(new class_241(10.0f, 4.0f)));
                    }
                });
            }
        }
    }

    public static void putData(class_2487 tag, class_3222 player, Object target, boolean showDetails) {
        List<IServerExtensionProvider<Object, class_2487>> list = WailaCommonRegistration.INSTANCE.progressProviders.get(target);
        for (IServerExtensionProvider<Object, class_2487> provider : list) {
            List groups = provider.getGroups(player, player.method_14220(), target, showDetails);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeProgress", groups, Function.identity())) {
                tag.method_10582("JadeProgressUid", provider.getUid().toString());
            }
            return;
        }
    }
}

