/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import java.io.File;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.UsernameCache;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.items.CapabilityItemHandler;
import snownee.jade.addon.forge.BlockInventoryProvider;
import snownee.jade.util.ClientPlatformProxy;

public final class PlatformProxy {
    @Nullable
    public static String getLastKnownUsername(UUID uuid) {
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static boolean isShears(ItemStack tool) {
        return tool.m_204117_(Tags.Items.SHEARS);
    }

    public static boolean isShearable(BlockState state) {
        return state.m_60734_() instanceof IForgeShearable;
    }

    public static boolean isCorrectToolForDrops(BlockState state, Player player) {
        return ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }

    public static String getModIdFromItem(ItemStack stack) {
        ResourceLocation id;
        String s;
        if (stack.m_41782_() && stack.m_41783_().m_128441_("id") && (s = stack.m_41783_().m_128461_("id")).contains(":") && (id = ResourceLocation.m_135820_((String)s)) != null) {
            return id.m_135827_();
        }
        return stack.m_41720_().getCreatorModId(stack);
    }

    public static boolean isPhysicallyClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static void init() {
        if (PlatformProxy.isPhysicallyClient()) {
            ClientPlatformProxy.init();
        }
    }

    public static void putHorseInvData(AbstractChestedHorse horse, CompoundTag data, int size) {
        horse.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> BlockInventoryProvider.putInvData(data, h, size, 2));
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }

    public static float getEnchantPowerBonus(BlockState state, Level world, BlockPos pos) {
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static ResourceLocation getId(Block block) {
        return Registry.f_122824_.m_7981_((Object)block);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return Registry.f_122826_.m_7981_(entityType);
    }

    public static ResourceLocation getId(BlockEntityType<?> blockEntityType) {
        return Registry.f_122830_.m_7981_(blockEntityType);
    }

    public static ResourceLocation getId(PaintingVariant motive) {
        return Registry.f_235728_.m_7981_((Object)motive);
    }
}

