/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.text2speech.Narrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.Accessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.callback.JadeRayTraceCallback;
import snownee.jade.api.callback.JadeTooltipCollectedCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DatapackBlockManager;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.RayTracing;
import snownee.jade.overlay.TooltipRenderer;

public class WailaTickHandler {
    private static WailaTickHandler INSTANCE = new WailaTickHandler();
    private static Narrator narrator;
    private static String lastNarration;
    public TooltipRenderer tooltipRenderer = null;
    public ProgressTracker progressTracker = new ProgressTracker();

    public void tickClient() {
        this.progressTracker.tick();
        WailaConfig.ConfigGeneral config = Jade.CONFIG.get().getGeneral();
        if (!config.shouldDisplayTooltip()) {
            this.tooltipRenderer = null;
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        if (!(client.f_91080_ instanceof BaseOptionsScreen) && (client.m_91104_() || client.f_91080_ != null || client.f_91068_ == null)) {
            return;
        }
        ClientLevel world = client.f_91073_;
        LocalPlayer player = client.f_91074_;
        if (world == null || player == null) {
            this.tooltipRenderer = null;
            return;
        }
        RayTracing.INSTANCE.fire();
        HitResult target = RayTracing.INSTANCE.getTarget();
        Tooltip tooltip = new Tooltip();
        if (target == null || target.m_6662_() == HitResult.Type.MISS) {
            this.tooltipRenderer = null;
            return;
        }
        Accessor<EntityHitResult> accessor = null;
        if (target instanceof BlockHitResult) {
            BlockHitResult blockTarget = (BlockHitResult)target;
            BlockState state = world.m_8055_(blockTarget.m_82425_());
            BlockEntity tileEntity = world.m_7702_(blockTarget.m_82425_());
            accessor = WailaClientRegistration.INSTANCE.blockAccessor().blockState(state).blockEntity(tileEntity).level((Level)world).player((Player)player).serverData(ObjectDataCenter.getServerData()).serverConnected(ObjectDataCenter.serverConnected).hit(blockTarget).fakeBlock(DatapackBlockManager.getFakeBlock((Level)world, blockTarget.m_82425_())).build();
        } else if (target instanceof EntityHitResult) {
            EntityHitResult entityTarget = (EntityHitResult)target;
            accessor = WailaClientRegistration.INSTANCE.entityAccessor().level((Level)world).player((Player)player).serverData(ObjectDataCenter.getServerData()).serverConnected(ObjectDataCenter.serverConnected).hit(entityTarget).entity(entityTarget.m_82443_()).build();
        }
        EntityAccessor originalAccessor = accessor;
        for (JadeRayTraceCallback callback : WailaClientRegistration.INSTANCE.rayTraceCallbacks) {
            accessor = callback.onRayTrace(target, accessor, originalAccessor);
        }
        ObjectDataCenter.set(accessor);
        if (accessor == null || accessor.getHitResult() == null) {
            this.tooltipRenderer = null;
            return;
        }
        if (!accessor.shouldDisplay()) {
            this.tooltipRenderer = null;
            return;
        }
        boolean showDetails = JadeClient.showDetails.m_90857_();
        if (accessor.isServerConnected()) {
            boolean request = accessor.shouldRequestData();
            if (ObjectDataCenter.isTimeElapsed(ObjectDataCenter.rateLimiter)) {
                ObjectDataCenter.resetTimer();
                if (request) {
                    accessor._requestData(showDetails);
                }
            }
            if (request && ObjectDataCenter.getServerData() == null) {
                return;
            }
        }
        if (config.getDisplayMode() == IWailaConfig.DisplayMode.LITE && !showDetails) {
            Tooltip dummyTooltip = new Tooltip();
            accessor._gatherComponents($ -> {
                if (Math.abs(WailaCommonRegistration.INSTANCE.priorities.get((IJadeProvider)$)) > 5000) {
                    return tooltip;
                }
                return dummyTooltip;
            });
            if (!dummyTooltip.isEmpty()) {
                tooltip.sneakyDetails = true;
            }
        } else {
            accessor._gatherComponents($ -> tooltip);
        }
        for (JadeTooltipCollectedCallback callback : WailaClientRegistration.INSTANCE.tooltipCollectedCallbacks) {
            callback.onTooltipCollected(tooltip, accessor);
        }
        this.tooltipRenderer = new TooltipRenderer(tooltip, true);
    }

    private static Narrator getNarrator() {
        return narrator == null ? (narrator = Narrator.getNarrator()) : narrator;
    }

    public static WailaTickHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new WailaTickHandler();
        }
        return INSTANCE;
    }

    public static void narrate(ITooltip tooltip, boolean dedupe) {
        if (!WailaTickHandler.getNarrator().active() || tooltip.isEmpty()) {
            return;
        }
        String narration = tooltip.getMessage();
        if (dedupe && narration.equals(lastNarration)) {
            return;
        }
        Narrator narrator = WailaTickHandler.getNarrator();
        narrator.say(narration, true);
        lastNarration = narration;
    }

    static {
        lastNarration = "";
    }
}

