/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import snownee.jade.Jade;
import snownee.jade.api.ui.IElement;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;

public class TooltipRenderer {
    private final Tooltip tooltip;
    private final boolean showIcon;
    private Vec2 totalSize;
    private float contentHeight;
    IElement icon;

    public TooltipRenderer(Tooltip tooltip, boolean showIcon) {
        this.showIcon = showIcon;
        this.tooltip = tooltip;
        if (showIcon) {
            this.icon = RayTracing.INSTANCE.getIcon();
        }
        this.computeSize();
    }

    public float getPadding() {
        return 2.0f;
    }

    public void computeSize() {
        float width = 0.0f;
        float height = 0.0f;
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            width = Math.max(width, size.f_82470_);
            height += size.f_82471_;
        }
        this.contentHeight = height;
        float padding = this.getPadding() * 2.0f;
        if (this.hasIcon()) {
            Vec2 size = this.icon.getCachedSize();
            width += 2.0f + size.f_82470_;
            height = Math.max(height, size.f_82471_ - 2.0f);
        }
        this.totalSize = new Vec2(width += padding + 4.0f, height += padding);
    }

    public void draw(PoseStack matrixStack) {
        float padding = this.getPadding();
        float x = padding + 3.0f;
        float y = padding + 1.0f;
        if (this.hasIcon()) {
            x += this.icon.getCachedSize().f_82470_ + 2.0f;
            if (this.icon.getCachedSize().f_82471_ > this.contentHeight) {
                y += (this.icon.getCachedSize().f_82471_ - this.contentHeight) / 2.0f - 1.0f;
            }
        }
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            line.render(matrixStack, x, y, this.totalSize.f_82470_ - padding - 1.0f, size.f_82471_);
            y += size.f_82471_;
        }
        if (this.tooltip.sneakyDetails) {
            Minecraft mc = Minecraft.m_91087_();
            x = (this.totalSize.f_82470_ - (float)mc.f_91062_.m_92895_("\u25be") + 1.0f) / 2.0f;
            float yOffset = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f;
            if (yOffset > 4.0f) {
                return;
            }
            y = this.totalSize.f_82471_ - 6.0f + yOffset;
            float alpha = 1.0f - Math.abs(yOffset) / 2.0f;
            int alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
            if (alphaChannel > 4) {
                mc.f_91062_.m_92883_(matrixStack, "\u25be", x, y, 0xFFFFFF | alphaChannel << 24);
            }
        }
    }

    public Tooltip getTooltip() {
        return this.tooltip;
    }

    public boolean hasIcon() {
        return this.showIcon && Jade.CONFIG.get().getOverlay().shouldShowIcon() && this.icon != null;
    }

    public Rect2i getPosition() {
        Window window = Minecraft.m_91087_().m_91268_();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        int x = (int)((float)window.m_85445_() * overlay.tryFlip(overlay.getOverlayPosX()));
        int y = (int)((float)window.m_85446_() * (1.0f - overlay.getOverlayPosY()));
        int width = (int)this.totalSize.f_82470_;
        int height = (int)this.totalSize.f_82471_;
        return new Rect2i(x, y, width, height);
    }

    public Vec2 getSize() {
        return this.totalSize;
    }
}

