/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import snownee.jade.Jade;
import snownee.jade.JadeClient;
import snownee.jade.api.callback.JadeAfterRenderCallback;
import snownee.jade.api.callback.JadeBeforeRenderCallback;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.config.Theme;
import snownee.jade.gui.BaseOptionsScreen;
import snownee.jade.impl.ObjectDataCenter;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.RayTracing;
import snownee.jade.overlay.TooltipRenderer;
import snownee.jade.overlay.WailaTickHandler;
import snownee.jade.util.Color;

public class OverlayRenderer {
    public static float ticks;
    public static int backgroundColorRaw;
    public static int gradientStartRaw;
    public static int gradientEndRaw;
    public static int stressedTextColorRaw;
    public static int normalTextColorRaw;

    public static void renderOverlay(PoseStack poseStack) {
        if (WailaTickHandler.instance().tooltipRenderer == null) {
            return;
        }
        if (!Jade.CONFIG.get().getGeneral().shouldDisplayTooltip()) {
            return;
        }
        if (Jade.CONFIG.get().getGeneral().getDisplayMode() == IWailaConfig.DisplayMode.HOLD_KEY && !JadeClient.showOverlay.m_90857_()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        if (RayTracing.INSTANCE.getTarget() == null) {
            return;
        }
        if (mc.f_91080_ != null) {
            if (!(mc.f_91080_ instanceof BaseOptionsScreen)) {
                return;
            }
            Rect2i position = WailaTickHandler.instance().tooltipRenderer.getPosition();
            WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
            Window window = mc.m_91268_();
            double x = mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_();
            double y = mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_();
            if (position.m_110087_((int)(x += (double)((float)position.m_110090_() * overlay.tryFlip(overlay.getAnchorX()))), (int)(y += (double)((float)position.m_110091_() * overlay.getAnchorY())))) {
                return;
            }
        }
        if (mc.f_91065_.m_93088_().f_94524_ || mc.m_91265_() != null || mc.f_91066_.f_92062_) {
            return;
        }
        if (mc.f_91066_.f_92063_ && Jade.CONFIG.get().getGeneral().shouldHideFromDebug()) {
            return;
        }
        ticks += mc.m_91297_();
        if (RayTracing.INSTANCE.getTarget().m_6662_() != HitResult.Type.MISS) {
            OverlayRenderer.renderOverlay(WailaTickHandler.instance().tooltipRenderer, poseStack);
        }
    }

    public static void renderOverlay(TooltipRenderer tooltip, PoseStack matrixStack) {
        Minecraft.m_91087_().m_91307_().m_6180_("Jade Overlay");
        matrixStack.m_85836_();
        Rect2i position = tooltip.getPosition();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        if (!overlay.getSquare()) {
            position.m_173056_(position.m_110090_() + 2);
            position.m_173058_(position.m_110091_() + 2);
        }
        JadeBeforeRenderCallback.ColorSetting colorSetting = new JadeBeforeRenderCallback.ColorSetting();
        colorSetting.alpha = overlay.getAlpha();
        colorSetting.backgroundColor = backgroundColorRaw;
        colorSetting.gradientStart = gradientStartRaw;
        colorSetting.gradientEnd = gradientEndRaw;
        for (JadeBeforeRenderCallback callback : WailaClientRegistration.INSTANCE.beforeRenderCallbacks) {
            if (!callback.beforeRender(tooltip.getTooltip(), position, matrixStack, ObjectDataCenter.get(), colorSetting)) continue;
            matrixStack.m_85849_();
            return;
        }
        if (!overlay.getSquare()) {
            position.m_173049_(position.m_110085_() + 1, position.m_110086_() + 1);
        }
        matrixStack.m_85837_((double)position.m_110085_(), (double)position.m_110086_(), 1.0);
        float scale = overlay.getOverlayScale();
        Window window = Minecraft.m_91087_().m_91268_();
        float thresholdHeight = (float)window.m_85446_() * overlay.getAutoScaleThreshold();
        if ((float)position.m_110091_() * scale > thresholdHeight) {
            scale = Math.max(scale * 0.5f, thresholdHeight / (float)position.m_110091_());
        }
        if (scale != 1.0f) {
            matrixStack.m_85841_(scale, scale, 1.0f);
        }
        matrixStack.m_85837_((double)((float)(-position.m_110090_()) * overlay.tryFlip(overlay.getAnchorX())), (double)((float)(-position.m_110091_()) * overlay.getAnchorY()), 0.0);
        if (colorSetting.alpha > 0.0f) {
            OverlayRenderer.drawTooltipBox(matrixStack, 0, 0, position.m_110090_(), position.m_110091_(), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.backgroundColor, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientStart, colorSetting.alpha), IWailaConfig.IConfigOverlay.applyAlpha(colorSetting.gradientEnd, colorSetting.alpha), overlay.getSquare());
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        tooltip.draw(matrixStack);
        RenderSystem.m_69461_();
        if (tooltip.hasIcon()) {
            Vec2 size = tooltip.icon.getCachedSize();
            Vec2 offset = tooltip.icon.getTranslation();
            float offsetY = overlay.getIconMode() == IWailaConfig.IconMode.TOP ? offset.f_82471_ + tooltip.getPadding() : ((float)position.m_110091_() - size.f_82471_) / 2.0f - 1.0f;
            float offsetX = offset.f_82470_ + tooltip.getPadding() + 2.0f;
            Tooltip.drawBorder(matrixStack, offsetX, offsetY, tooltip.icon);
            tooltip.icon.render(matrixStack, offsetX, offsetY, offsetX + size.f_82470_, offsetY + size.f_82471_);
        }
        for (JadeAfterRenderCallback callback : WailaClientRegistration.INSTANCE.afterRenderCallbacks) {
            callback.afterRender(tooltip.getTooltip(), position, matrixStack, ObjectDataCenter.get());
        }
        RenderSystem.m_69482_();
        matrixStack.m_85849_();
        Minecraft.m_91087_().m_91307_().m_7238_();
        if (Jade.CONFIG.get().getGeneral().shouldEnableTextToSpeech() && Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91073_.m_46467_() % 5L == 0L) {
            WailaTickHandler.narrate(tooltip.getTooltip(), true);
        }
    }

    public static void drawTooltipBox(PoseStack matrixStack, int x, int y, int w, int h, int bg, int grad1, int grad2, boolean square) {
        if (!square) {
            w -= 2;
            h -= 2;
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + 1, y + 1, w - 2, h - 2, bg, bg);
        if (!square) {
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y - 1, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h, w, 1.0f, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x - 1, y, 1.0f, h, bg, bg);
            DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w, y, 1.0f, h, bg, bg);
        }
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x + w - 1, y + 1, 1.0f, h - 2, grad1, grad2);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y, w, 1.0f, grad1, grad1);
        DisplayHelper.INSTANCE.drawGradientRect(matrixStack, x, y + h - 1, w, 1.0f, grad2, grad2);
    }

    public static void updateTheme() {
        Theme theme = Jade.CONFIG.get().getOverlay().getTheme();
        backgroundColorRaw = Color.fromString(theme.backgroundColor).toInt();
        gradientEndRaw = Color.fromString(theme.gradientEnd).toInt();
        gradientStartRaw = Color.fromString(theme.gradientStart).toInt();
        normalTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.fromString(theme.normalTextColor).toInt(), 1.0f);
        stressedTextColorRaw = IWailaConfig.IConfigOverlay.applyAlpha(Color.fromString(theme.stressedTextColor).toInt(), 1.0f);
    }
}

