/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import snownee.jade.Jade;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestTilePacket;
import snownee.jade.util.WailaExceptionHandler;

public class RequestEntityPacket {
    public int entityId;
    public boolean showDetails;

    public RequestEntityPacket(Entity entity, boolean showDetails) {
        this(entity.m_19879_(), showDetails);
    }

    private RequestEntityPacket(int entityId, boolean showDetails) {
        this.entityId = entityId;
        this.showDetails = showDetails;
    }

    public static RequestEntityPacket read(FriendlyByteBuf buffer) {
        return new RequestEntityPacket(buffer.m_130242_(), buffer.readBoolean());
    }

    public static void write(RequestEntityPacket message, FriendlyByteBuf buffer) {
        buffer.m_130130_(message.entityId);
        buffer.writeBoolean(message.showDetails);
    }

    public static class Handler {
        public static void onMessage(RequestEntityPacket message, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                Level world = player.f_19853_;
                Entity entity = world.m_6815_(message.entityId);
                if (entity == null || player.m_20280_(entity) > (double)RequestTilePacket.MAX_DISTANCE_SQR) {
                    return;
                }
                List<IServerDataProvider<Entity>> providers = WailaCommonRegistration.INSTANCE.getEntityNBTProviders(entity);
                if (providers.isEmpty()) {
                    return;
                }
                CompoundTag tag = new CompoundTag();
                for (IServerDataProvider<Entity> provider : providers) {
                    try {
                        provider.appendServerData(tag, player, world, entity, message.showDetails);
                    }
                    catch (Exception e) {
                        WailaExceptionHandler.handleErr(e, provider, null);
                    }
                }
                tag.m_128405_("WailaEntityID", entity.m_19879_());
                Jade.NETWORK.sendTo((Object)new ReceiveDataPacket(tag), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            });
            context.get().setPacketHandled(true);
        }
    }
}

